\name{changes}
\alias{changes}
\title{Changes Made to the Package}
\description{
This page contains a list of recent changes made to the package, and known general problems.
}
\details{
\enumerate{
\item The map plotting option in \code{\link{lattice}} has been removed, along with the default values for \code{alpha}, \code{d}, \code{centrelong} and \code{centrelat} in the function call. These must now be set explicitly. (March 2003)

\item The function \code{subcatalogue} has been deleted. It is superseded by \code{\link{as.catalogue}}. (June 2003)

\item The function \code{print.cat} has been renamed to \code{\link{write.catalogue}}. (June 2003)

\item Fixed inconsistencies between generic and method functions. (June 2003)

\item The function \code{c.cat} has been renamed to \code{\link{c.catalogue}} providing a \dQuote{combine} method for objects with class \code{"catalogue"}. (June 2003)

\item \code{\link{c.catalogue}}: argument \code{name} has been changed to \code{catname}. (June 2003)

\item The function \code{plot.subset} has been moved to the ssEDA package. (June 2003)

\item \code{\link{subset.circle}}, \code{\link{subset.polygon}}, \code{\link{subset.rect}}, \code{\link{subset.sphere}}: argument \code{na.rm} added. Its effect has been described under \sQuote{Details} of the documentation of each function. (June 2003)

\item \code{\link{library.version}}: updated. (August 2003)

\item \code{\link{library.version}}: version above included a stray CR causing a syntax error. (September 2003)

\item \code{\link{Palliser}} Catalogue added. (September 2003)

\item \code{\link{as.catalogue}} modified to be compatible with \R\ version 1.7.1. A list now has class \code{"list"}. (October 2003)

\item \code{ReadNZ}, \code{ReadPDE} and \code{ReadWellington} have been deleted, now part of respective packages. (October 2003)

\item \code{\link{days1}} and \code{\link{projection}}: links to functions in other packages in manual pages modified to include the package name. (November 2003)

\item Minor documentation formatting changes, mainly to use \code{\\dQuote} and \code{\\sQuote}. (January 2004)

\item \code{\link{summary.catalogue}}: gave a warning message if all values of depth were missing; fixed. (February 2004)

\item \code{\link{epi.circle}}: argument \code{plotit} removed. (February 2004)

\item Catalogue \code{Read} functions has been removed from this package, with each catalogue package containing its ``read'' function. (March 2004)

\item File \file{/exec/version.sh} removed from package. (March 2004)

\item \code{\link{library.version}}: documentation mismatch with code corrected. (7 May 2004)

\item \code{\link{subset.polygon}}: \code{PACKAGE="ssBase"} has been added to the \code{.Fortran("polyse", ...)} call within the function. (7 May 2004)

\item \code{\link{Palliser}}, \code{\link{NZ55}}: in earlier package versions these datasets were read from a text file creating the rda file at the time \code{data(Palliser)} or \code{data(NZ55)} were ran. This method caused a syntax error in \R\ 2.0. Now this file is created when the package is installed, similar to the catalogue packages. (22 Nov 2004)

\item \code{\link{summary.subset}}: syntax error in \R\ 2.0 caused by multiple inequalities in an expression. A \code{phantom()} has been added to the initial \code{if (plot == TRUE)} statement. (22 Nov 2004)

\item \code{\link{subset.circle}}, \code{\link{subset.polygon}}, \code{\link{subset.sphere}}: documentation formatting changes to use \code{\\eqn}. (16 Feb 2005)

\item \code{\link{arcdist}}: new function. (16 Feb 2005)

\item \code{\link{lattice}}: rearrange function code. (18 Feb 2005)

\item \code{\link{write.catalogue}}: writing loop eliminated, and use made of \R\ functions \code{\link[base]{format}} and \code{\link[base]{formatC}}. (20 Feb 2005)

\item \code{\link{c.catalogue}}: function rewritten, user can now select a subset of variables to include. (20 Feb 2005)

\item \code{\link{subset.circle}}, \code{\link{subset.polygon}}, \code{\link{subset.rect}}, \code{\link{subset.sphere}}: documentation for arguments \code{minday} and \code{maxday} clarified. (April 2005)

\item \code{\link{days1}}, \code{\link{datetimes}}: clearer explanation on the manual pages of the difference between these functions and similar functions in the \pkg{chron} package. (29 April 2005)

\item In src/Makefile.win there were three occurrences of \dQuote{\code{$(RM) -f}}, each of were replaced by \dQuote{\code{$(RM)}}. The in-built definition for RM already contains the \dQuote{\code{-f}}. (20 June 2005)

\item Package vignettes added. (13 Aug 2005)

\item \code{\link{days1}}, \code{\link{months1}}, \code{\link{years1}}: the \pkg{chron} package implemented a namespace in version 2.3-0. To call the chron function \code{origin}, one now needs \code{chron:::origin}; though here have replaced with \code{attr(x, "origin")}. (28 Nov 2005)

\item \code{\link{days1}}: error in example fixed (\dQuote{1959} to \dQuote{1969}). (28 Nov 2005)

\item More problems with Windows! New version of \file{src/Makefile.win}. (16 Dec 2005)

\item Modify \file{src/Makefile.win} (missing tabs). (17 Dec 2005)

\item \code{\link{lattice}}: \code{d} included in output list. (4 May 2006)

\item File \file{R/NZ55.txt} deleted, is in \file{src/NZ55.txt}. (12 May 2006)

\item File \file{R/[.datetimes.R} renamed to \file{R/extract.datetimes.R}. (12 May 2006)

\item In \file{src/Makefile.win} line containing \code{DLLLIBS = -L$(RHOME)/lib -L$(RHOME)/src/gnuwin32 -lR} deleted. (10 Jul 2007)

\item \code{\link{c.catalogue}}: arguments \code{...} and \code{recursive} added for compatibility with generic function \code{\link[base]{c}}. (2 Aug 2007)

\item The functions \code{subset.rect}, \code{subset.circle}, \code{subset.polygon}, and \code{subset.sphere} are deprecated and have been renamed to \code{\link{subsetrect}}, \code{\link{subsetcircle}}, \code{\link{subsetpolygon}}, and \code{\link{subsetsphere}}, respectively. Their names conflict with the generic \R\ function \code{\link[base]{subset}}. (5 Nov 2007)

\item \code{subset.rect}, \code{subset.polygon}, and \code{subset.sphere}: correct incorrect information in the deprecated warning message. (21 Nov 2007)
}}



\section{Future Developments}{
\enumerate{
\item Make \code{"datetimes"} compatible with base software provided by \R. Still insufficient flexibility in the \pkg{chron} functions.

\item Write a function \code{subset.catalogue} as a method for \code{\link[base]{subset}}. It would involve \code{\link{subsetcircle}}, \code{\link{subsetpolygon}}, \code{\link{subsetrect}}, and \code{\link{subsetsphere}}.
}
}

\keyword{documentation}
