\name{datetimes}
\alias{datetimes}
\title{
Calculate Dates and Times
}
\description{
Calculates the number of days and fractions thereof from the 1 January 1970.
}
\usage{
datetimes(year, month, day, hour, minute, second=0, dp.second=NA,
          missing = FALSE)
}
\arguments{
\item{year}{
an integer, e.g. 1998.
}
\item{month}{
an integer with values 1, 2, \dots, 12.
}
\item{day}{
an integer giving the day of the month, e.g. 1, 2, \dots, 31.
}
\item{hour}{
an integer giving the hour of the day, i.e. 0, 1, 2, \dots, 23.
}
\item{minute}{
an integer giving the minute of the hour, i.e. 0, 1, 2, \dots, 59.
}
\item{second}{
a numeric vector giving the seconds, e.g. 32.45. The number of decimal places should be consistent with dp.second below. Default is zero.
}
\item{dp.second}{
an integer giving the number of decimal places specified in second. Default is \code{NA}, i.e. not specified. In this case zero is used in all calculations.
}
\item{missing}{
logical, default is \code{FALSE}. Indicates whether information about the extent of missing values should be passed out of the function.
}}
\value{
If \code{missing} == \code{FALSE}, then only a datetimes object is returned. If \code{TRUE}, a list object which contains a datetimes object called \code{ti} and an object called \code{missing} is returned.


A datetimes object is a numeric vector with class \code{"datetimes"}, and values for each date that are the number of days and fractions thereof from 00:00:00hrs on 1 January 1970. This object also has attributes \code{"origin"} which species the origin date, and \code{"dp.second"} which specifies the accuracy of the variable \code{second}. This information will determine the number of decimal places used to print the object. By default, the object will be printed in the format DDMMMYYYY hh:mm:ss.s, where the number of decimal places is specified as above.


The vector \code{missing} is character, taking values \code{"Y"}, \code{"M"}, \code{"D"}, \code{"h"}, \code{"m"}, \code{"s"}, corresponding to whether the \code{year}, \code{month}, \code{day}, \code{hour}, \code{minute} or \code{second} is missing, respectively. Where more than one of these values are missing then \code{missing} takes the first one from \code{c("Y", "M", "D", "h", "m", "s")}. When \code{month} or \code{day} is missing, one is used in calculations; and where \code{hour}, \code{minute} or \code{second} are missing, zero is used in calculations.

The main difference with the \code{\link[chron]{chron}} function in package \pkg{chron} is that the \code{datetimes} function has a facility to account for fractional seconds, and also missing values as described above.
}

\seealso{
\code{\link{format.datetimes}}, \code{\link{[.datetimes}},
\code{\link{print.datetimes}}, \code{\link{years1}}, \code{\link{months1}},
\code{\link{days1}}
}
\examples{
a <- datetimes(1998, 6, 2, 13, 34, 25.9, dp.second=1)
print(a)
print.default(a)
format(a)
}

\keyword{chron}
\keyword{classes}
