\name{days1}
\alias{days1}
\alias{months1}
\alias{years1}
\title{
Day, Month and Year of Datetimes Value
}
\description{
These functions act in a similar way as the \pkg{chron} functions \code{\link[chron:days]{days}}, \code{\link[chron:days]{months}} and \code{\link[chron:days]{years}}. See \dQuote{Details} below.
}
\usage{
days1(x)
months1(x)
years1(x)
}
\arguments{
\item{x}{
a datetimes object.
}}
\value{
A numeric vector of the same length as \code{x} giving either the day of the month (1, \dots, 31), the month (1, \dots, 12), or the year (e.g. 1998).
}
\details{
The datetimes object is a numeric vector containing the number of days and fractions thereof from some defined origin, often 1 Jan 1970.

In versions of \pkg{chron} prior to 2.2-35, there was a bug. This caused the functions \code{\link[chron:days]{days}}, \code{\link[chron:days]{months}}, and \code{\link[chron:days]{years}} to sometimes be erroneous for dates before the origin. For example, \code{chron(dates.="12/31/1969", times.="18:00:00")} would give \code{"01/01/1970  -6:00:00"}. This appears to have been fixed in version 2.2-35. It was probably caused by a call to \code{\link[base:Round]{trunc}} in \code{\link[chron:day.of.week]{month.day.year}} rather than \code{\link[base:Round]{floor}}.

Another difference is that the values returned by the \pkg{chron} functions \code{\link[chron:days]{days}}, \code{\link[chron:days]{months}}, and \code{\link[chron:days]{years}} are ordered factors. This is not the case for \code{days1}, \code{months1} and \code{years1}. 
}

\seealso{
\code{\link{datetimes}}, \code{\link[chron:days]{days}}, \code{\link[chron:days]{months}}, \code{\link[chron:days]{years}}, \code{\link{hrs.mins.secs}}
}
\examples{
x <- julian(12,31,1969) + 18/24
print(x)
#   x represents 18:00:00 hrs on 31 Dec 1969
#   x = -1 + 18/24 = -0.25

x <- datetimes(1998, 6, 2, 13, 34, 25.9, dp.second=1)
print(days1(x))
print(months1(x))
print(years1(x))
print(hrs.mins.secs(x))
}

\keyword{chron}
