\name{epi.circle}
\alias{epi.circle}
\title{
Calculate Epicentral Coordinates of a Circle
}
\description{
Calculates the epicentral coordinates of 399 points on the perimeter of a circle of given radius centred at (centrelong, centrelat). The circle radius is the arc length radius on the surface of the earth.
}
\usage{
epi.circle(centrelong, centrelat, radius, earthradius=6371)
}
\arguments{
\item{centrelong}{
a number specifying the longitude in degrees of the circle centre.
}
\item{centrelat}{
a number specifying the latitude in degrees of the circle centre.
}
\item{radius}{
a number specifying the circle radius in kilometres.
}
\item{earthradius}{
assumed radius of the earth in kilometres. The default is 6371 km.
}
}
\value{
If the function call is assigned to another object, then a list object is returned.	It contains the following components.

\item{centrelong}{
as specified above.
}
\item{centrelat}{
as specified above.
}
\item{radius}{
as specified above.
}
\item{longitude}{
a vector giving the longitude of 399 points on the circle perimeter.
}
\item{latitude}{
a vector giving the latitude of 399 points on the circle perimeter.
}}
\author{Yang Wenzheng, 1998}

\examples{
x <- epi.circle(175, -42, 3000)

#   Now project the circle outline
y <- projection(6371, x$latitude, x$longitude, 175, -42)
par(pin=c(5,5))
plot(y$x, y$y, type="l")
}

\keyword{utilities}
