\name{hrs.mins.secs}
\alias{hrs.mins.secs}
\title{
Calculates Hours, Minutes and Seconds
}
\description{
Given a datetime object (vector), the time represented by each element on a 24 hour clock is returned.
}
\usage{
hrs.mins.secs(x)
}
\arguments{
\item{x}{
a datetime vector object.
}}
\value{
A list object with the following components:

\item{hour}{
a vector of the hours (0, \dots, 23).
}
\item{minute}{
a vector of the minutes (0, \dots, 59).
}
\item{second}{
a vector of the seconds (0, \dots, 59.9).
}}
\seealso{
\code{\link{datetimes}}, \code{\link{years1}}, \code{\link{months1}}, \code{\link{days1}}
}
\examples{
x <- datetimes(year=1998, month=8, day=25, hour=20, minute=33,
               second=24.5, dp.second=1)
hrs.mins.secs(x)
}

\keyword{chron}
