\name{lattice}
\alias{lattice}
\title{
Creates Lattice of Points on Sphere Surface
}
\description{
A lattice of \eqn{(2J+1)}{(2*J+1)} by \eqn{(2K+1)}{(2*K+1)} grid points
based on squares or equilateral triangles (at a fixed distance, \eqn{d}
apart) is calculated centred on a specified point and with a given orientation. 


The major axis of the lattice is taken along the great circle through the lattice centre in the direction specified by the orientation alpha.
}
\usage{
lattice(K, J, d, alpha, centrelat, centrelong, triangle=TRUE)
}
\arguments{
\item{K}{
the number of points stepped off to the left and to the right of the origin along the major axis.
}
\item{J}{
the number of points stepped off in both directions orthogonal to the major axis.
}
\item{d}{
the distance between the lattice points (in kilometres).
}
\item{alpha}{
\eqn{\pi/2}{pi/2} minus \code{alpha} gives the angle (in radians) between the local meridian through the lattice centre and the major axis of the lattice, where \code{alpha} is between 0 and \eqn{\pi}{pi}.
}
\item{centrelat}{
the latitude component of the centre (origin) of the grid.
}
\item{centrelong}{
the longitude component of the centre (origin) of the grid.
}
\item{triangle}{
logical. If \code{TRUE}, a triangular grid is calculated. If \code{FALSE}, a square grid is calculated.
}
}

\value{
A list object is returned. It contains the following components:

\item{centrelong}{
as specified above.
}
\item{centrelat}{
as specified above.
}
\item{d}{
the distance between the lattice points (in kilometres).
}
\item{longitude}{
a vector giving the longitude of the grid points.
}
\item{latitude}{
a vector giving the latitude component of the grid points.
}
\item{i}{
a vector of sequence numbers of the lattice points, starting from 1 in the south western corner.
}
\item{j}{
a vector of grid coordinates along the major axis of the lattice, with 0 as the centre.
}
\item{k}{
a vector of grid coordinates orthogonal to the major axis of the lattice, with 0 as the centre.
}}
\details{
A lattice of \eqn{(2J+1)}{(2*J+1)} by \eqn{(2J+1)}{(2*K+1)} grid points based on equilateral triangles (at a fixed distance, \eqn{d} apart) or squares is calculated. The grid is rotated by the angle \code{alpha}. The algorithm from \code{\link{epi.circle}} is subsequently used to convert to spherical coordinates, centred over the specified origin. The spherical coordinates (longitude, latitude) of the grid points are returned in a list.
}

\author{Alistair Merrifield, 1998}

\seealso{
\code{\link{lattice.retrieve}}
}
\examples{
#   Creates a triangular lattice of 207 points centred over (175, -41)

x <- lattice(J=4, K=11, d=120, alpha=pi/4, centrelat=-41, 
             centrelong=175, triangle=TRUE)

plot(x$longitude, x$latitude, xlab="Longitude", ylab="Latitude",
     main="Triangluar Arrangement")

x <- lattice(J=4, K=11, d=120, alpha=pi/4, centrelat=-41, 
             centrelong=175, triangle=FALSE)

plot(x$longitude, x$latitude, xlab="Longitude", ylab="Latitude",
     main="Rectangular Arrangement")
}

\keyword{utilities}


 
