\name{lattice.retrieve}
\alias{lattice.retrieve}
\title{
Determine Lattice Indices for Given Circle
}
\description{
This is a complementary function to the function \code{\link{lattice}}. The function \code{\link{lattice}} calculates longitude-latitude centres for a
\eqn{(2J+1)}{(2*J+1)} by \eqn{(2K+1)}{(2*K+1)} grid. It produces a
vector of \eqn{(2J+1)(2K+1)}{(2*J+1)*(2*K+1)} centres. Given the
\eqn{i}{i}th centre, \code{lattice.retrieve} calculates the corresponding
values of \eqn{j}{j} and \eqn{k}{k}. Alternatively, given \eqn{j}{j} and
\eqn{k}{k}, the function returns the corresponding index \eqn{i}{i}. 
}
\usage{
lattice.retrieve(i, K, J)
lattice.retrieve(j, k, K, J)
}
\synopsis{
lattice.retrieve(i, j, k, K, J)
}
\arguments{
\item{i}{
the index number of the centre of interest.
}
\item{j}{
scalar where \eqn{-J \leq j \leq J}{-J <= j <= J}, and \eqn{J}{J} is defined in the documentation for the function \code{\link{lattice}}.
}
\item{k}{
scalar where \eqn{-K \leq k \leq K}{-K <= k <= K}, and \eqn{K}{J} is defined in the documentation for the function \code{\link{lattice}}.
}
\item{K}{
see documentation for the function \code{\link{lattice}}.
}
\item{J}{
see documentation for the function \code{\link{lattice}}.
}}
\value{
Returns a list object with the values of i, j, k, J, and K.
}
\seealso{
\code{\link{lattice}}
}

\keyword{utilities}
