\name{projection}
\alias{projection}
\title{
Transforms Spherical Coordinates to Cartesian
}
\description{
Transforms spherical coordinates to Cartesian and rotates. Have
spherical coordinates \eqn{(\rho,\phi,\theta)}{\code{(rho,
	phi,theta)}}. \code{rho} (\eqn{\rho}) is the radius,
\code{theta} (\eqn{\theta} can be thought of as the longitude and
\code{phi} (\eqn{\phi}) the latitude. The resultant coordinates
\eqn{(x,y,z)}{(x,y,z)} are rotated such that the point with longitude
\code{alpha} (\eqn{\alpha}) and latitude \code{beta} (\eqn{\beta}) becomes
the new north pole. Thus a plot of the new \eqn{x y}{x*y} plane is
Azimuths projection, centered at the new reference point. 
}
\usage{
projection(rho, phi, theta, alpha, beta)
}
\arguments{
\item{rho}{
a vector with the radius component of the original spherical coordinates for each point.
}
\item{phi}{
a vector with the latitude component of the original spherical coordinates for each point.
}
\item{theta}{
a vector with the longitude component of the original spherical coordinates for each point.
}
\item{alpha}{
a scalar giving the longitude of the centre of the new hemisphere (pole).
}
\item{beta}{
a scalar giving the latitude of the centre of the new hemisphere (pole).
}}
\value{
A list object containing the following vectors of the same length:

\item{x}{
the x component of the new Cartesian coordinates.
}
\item{y}{
the y component of the new Cartesian coordinates.
}
\item{z}{
the z component of the new Cartesian coordinates.
}}
\seealso{
\code{\link[ssEDA]{hemisphere}}
}

\keyword{algebra}
\keyword{utilities}
