\name{subsetpolygon}
\alias{subset.polygon}
\alias{subsetpolygon}
\title{
Polygon Subset of Events
}
\description{
Selects events within a specified polygon from a given catalogue. Note that \code{subset.polygon} is deprecated; it conflicts with the generic function \code{\link[base]{subset}}. Change to \code{subsetpolygon}; it has the same arguments.
}
\usage{
subsetpolygon(x, polylong, polylat, mindepth=0, maxdepth=Inf,
              minmag=-Inf, maxmag=Inf, minday=-Inf, maxday=Inf,
              report.count=TRUE, na.rm=TRUE, ...)

#   Deprecated Usage:
subset.polygon(x, polylong, polylat, mindepth=0, maxdepth=Inf,
               minmag=-Inf, maxmag=Inf, minday=-Inf, maxday=Inf,
               report.count=TRUE, na.rm=TRUE, ...)
}
\arguments{
\item{x}{
catalogue name.
}
\item{polylong}{
vector containing the longitudes of the polygon corners in the order as one 
travels the perimeter. Specified as degrees east of Greenwich (0 to 360).
}
\item{polylat}{
vector containing the latitudes of the polygon corners in the order as one 
travels the perimeter. Specified as degrees north (positive) or south (negative) 
of the equator (\eqn{-90} to \eqn{90}).
}
\item{mindepth}{
minimum depth in kilometres.
}
\item{maxdepth}{
maximum depth in kilometres.
}
\item{minmag}{
minimum magnitude.
}
\item{maxmag}{
maximum magnitude.
}
\item{minday}{
the number of days (and fractions) after 00:00 hrs on 1 January 1970 from which events are required. See Details.
}
\item{maxday}{
the number of days (and fractions) after 1 January 1970 denoting the upper bound of the time interval containing the required events. See Details.
}
\item{report.count}{
Boolean. Report the number of events referred to by the new subset. Default is \code{TRUE}.
}
\item{na.rm}{
Boolean. Determines whether those events with missing values of the subsetting variables should be excluded, see Details.  Default is \code{TRUE}.
}
\item{...}{
other options for restricting Catalogue data. These must take the form \code{option == value}, where \code{option} is a component of the specified catalogue.
}}
\details{
Events are initially selected within the rectangle defined by \code{range(polylong)} and \code{range(polylat)}. The \code{outside} component in the returned object are the indices of those events within this rectangle but outside the polygon. Events with a missing latitude or longitude will always be excluded regardless of the value of the argument \code{na.rm}.

The subsetting then determines those events within the required magnitude-depth-time window. The default settings for each of these variables is to take all events. The function only works through each of the \dQuote{min} and \dQuote{max} values \emph{included in your function call}. Those arguments \emph{not explicitly listed will have no effect}. Events within the required magnitude-depth-time window are then divided into those \sQuote{inside} and \sQuote{outside} of the polygon. A logical vector is constructed with the same length as the number of events in the catalogue, and indicates whether a given event satisfies the subsetting criteria. From this, the vector of indices of the required events is created.

Historical events often have missing values, particularly the magnitude and depth. Consider the situation where \code{minmag=6}. The logical vector within the function will contain \code{TRUE}'s and \code{FALSE}'s for those events that satisfy or not satisfy this condition, respectively. However, for those historical events with a missing magnitude (\code{NA}), the elements in the logical vector will also be \code{NA}. The argument \code{na.rm} determines whether these events should be removed (\code{TRUE}) or included (\code{FALSE}) in the subset. The default setting is to remove such events, though in the context of large historical events, it would be more sensible to include them, i.e. \code{na.rm=FALSE}.

The arguments \code{minday} and \code{maxday} represent the boundary \emph{points} of the time interval, and can represent fractions of days. For example, 00:00 hrs on 1 Jan 1970 is represented as \code{minday=0}, whereas 18:00 hrs on 2 Jan 1970 is represented as \code{minday=1.75}. Similarly, 18:32:24 hrs on 30 Sept 1990 could be specified as \code{minday = julian(9,30,1990) + 18/24 + 32/(24*60) + 24/(24*60*60)}. Note that \code{maxday = julian(1,1,1990)} represents the \emph{point} 00:00 hrs on 1 Jan 1990, and therefore will not include events on 1 Jan 1990 after midnight.
}

\value{
Returns an object of type list of class \code{"subset"}. All values of optional arguments 
above, plus the specified values of \code{polylong} and \code{polylat}, are included as elements within 
the list. Other components within the list are:

\item{indices}{
an array of indices for events in catalogue x satisfying the selection criteria.
}
\item{catname}{
catalogue name.
}
\item{outside}{
see details.
}
\item{type}{
type of subset, set to \code{"Polygon"}.
}}

\seealso{
\code{\link{subsetcircle}}, \code{\link{subsetrect}}, 
\code{\link{subsetsphere}}, \code{\link{print.subset}}, 
\code{\link{summary.subset}}
}
\examples{
#  Select events from NZ55 within following polygon
polylong <- c(173.8, 174.3, 174.8, 174.4, 174.8, 175.6,175,174.5)
polylat <- c(-41.5, -40.5, -40.9, -41, -41.4, -41, -41.8, -41.25)

data(NZ55)
a <- subsetpolygon(NZ55, polylong, polylat)

#  plot points within polygon
plot(NZ55$longitude[a$indices], NZ55$latitude[a$indices], cex=2,
     xlim=range(polylong), ylim=range(polylat), pch=16, col="red")
points(c(polylong,polylong[1]), c(polylat, polylat[1]), type='l', lty=2)
}

\keyword{manip}
