\name{subsetsphere}
\alias{subset.sphere}
\alias{subsetsphere}
\title{
Spherical Subset of Events
}
\description{
Selects events within a specified spherical selection criteria (i.e. a given 
radius from a hypocentral location), from a given catalogue. Note that \code{subset.sphere} is deprecated; it conflicts with the generic function \code{\link[base]{subset}}. Change to \code{subsetsphere}; it has the same arguments.
}
\usage{
subsetsphere(x, centrelat=0, centrelong=0, centredepth=0, minradius=0,
	     maxradius=Inf, minmag=-Inf, maxmag=Inf, minday=-Inf,
	     maxday=Inf, radius=6371, report.count=TRUE, na.rm=TRUE, ...)

#   Deprecated Usage:
subset.sphere(x, centrelat=0, centrelong=0, centredepth=0, minradius=0,
	      maxradius=Inf, minmag=-Inf, maxmag=Inf, minday=-Inf,
	      maxday=Inf, radius=6371, report.count=TRUE, na.rm=TRUE, ...)
}
\arguments{
\item{x}{
catalogue name.
}
\item{centrelat}{
latitude of the sphere centre. Specified as degrees north (positive) or south 
(negative) of the equator (\eqn{-90} to \eqn{90}).
}
\item{centrelong}{
longitude of the sphere centre. Specified as degrees east of Greenwich (0 to 
360).
}
\item{centredepth}{
depth of the sphere centre.
}
\item{minradius}{
arclength radius (km) within which events are not to be selected.
}
\item{maxradius}{
arclength radius (km) within which events to be selected.
}
\item{minmag}{
minimum magnitude.
}
\item{maxmag}{
maximum magnitude.
}
\item{minday}{
the number of days (and fractions) after 00:00 hrs on 1 January 1970 from which
events are required. See Details.
}
\item{maxday}{
the number of days (and fractions) after 1 January 1970 denoting the upper bound 
of the time interval containing the required events. See Details.
}
\item{radius}{
the assumed radius of the earth. Default is 6371 km.
}
\item{report.count}{
Boolean. Report the number of events referred to by the new subset. Default is
\code{TRUE}.
}
\item{na.rm}{
Boolean. Determines whether those events with missing values of the subsetting variables should be excluded, see Details.  Default is \code{TRUE}.
}
\item{...}{
other options for restricting Catalogue data. These must take the form 
\code{option == value}, where \code{option} is a component of the specified 
catalogue.
}}

\details{
The subsetting is based on the catalogue variables \code{latitude}, \code{longitude}, \code{depth}, \code{magnitude} and \code{time}. The default settings for each of these variables is to take all events. The function only works through each of the \dQuote{min} and \dQuote{max} values for \code{magnitude} and \code{time} \emph{included in your function call}. Those arguments \emph{not explicitly listed will have no effect}. For each event in the correct magnitude-time window, its distance from the centre of the sphere is calculated. A logical vector is constructed with the same length as the number of events in the catalogue, and indicates whether a given event satisfies the subsetting criteria. From this, the vector of indices of the required events is created.

Historical events often have missing values, particularly the magnitude and depth. Consider the situation where \code{minmag=6}. The logical vector within the function will contain \code{TRUE}'s and \code{FALSE}'s for those events that satisfy or not satisfy this condition, respectively. However, for those historical events with a missing magnitude or depth (\code{NA}), the elements in the logical vector will also be \code{NA}. The argument \code{na.rm} determines whether these events should be removed (\code{TRUE}) or included (\code{FALSE}) in the subset. The default setting is to remove such events, though in the context of large historical events, it would be more sensible to include them, i.e. \code{na.rm=FALSE}.

The arguments \code{minday} and \code{maxday} represent the boundary \emph{points} of the time interval, and can represent fractions of days. For example, 00:00 hrs on 1 Jan 1970 is represented as \code{minday=0}, whereas 18:00 hrs on 2 Jan 1970 is represented as \code{minday=1.75}. Similarly, 18:32:24 hrs on 30 Sept 1990 could be specified as \code{minday = julian(9,30,1990) + 18/24 + 32/(24*60) + 24/(24*60*60)}. Note that \code{maxday = julian(1,1,1990)} represents the \emph{point} 00:00 hrs on 1 Jan 1990, and therefore will not include events on 1 Jan 1990 after midnight.
}

\value{
Returns an object of type list with class \code{"subset"}. All optional 
arguments above, except radius, are included as elements within the list. Other 
components within the list are:

\item{indices}{
an array of indices for events in catalogue \code{x} satisfying the selection 
criteria.
}
\item{catname}{
catalogue name.
}
\item{type}{
type of subset, set to \code{"Spherical"}.
}}

\seealso{
\code{\link{subsetcircle}}, \code{\link{subsetpolygon}}, 
\code{\link{subsetrect}}, \code{\link{print.subset}}, 
\code{\link{summary.subset}}
}
\examples{
#   Select events from the NZ55 catalogue with hypocentre no more
#   than 50kms from Wellington, but at least 20kms from Wellington.
data(NZ55)

b <- subsetsphere(NZ55, centrelat=-41.3, centrelong=174.8, 
                   maxradius=100, minradius=20, minmag=2)
summary(b)
}

\keyword{manip}
