\name{summary.catalogue}
\alias{summary.catalogue}
\title{
Summary of Earthquake Catalogue
}
\description{
Provides a method for the generic function \code{\link{summary}} on objects of class \code{"catalogue"}.
}
\usage{
\method{summary}{catalogue}(object, ...)
}
\arguments{
\item{object}{
name of the earthquake catalogue. The catalogue is a list object with class \code{"catalogue"}.
}
\item{\dots}{
other options for summarising \code{"catalogue"} objects.
}
}
\value{
An object is returned with the following components.

\item{catname}{
character string containing name of the catalogue.
}
\item{n}{
number of events in the catalogue.
}
\item{ranges}{
a matrix giving the minimum, maximum and number of missing values for each of latitude, longitude, depth and magnitude.
}
\item{time.range}{
vector of length 2 giving the datetime of the first and last events within the catalogue.
}
\item{missing.times}{
a matrix where each row relates to an event with a missing component in its time. The first column gives the record number, 2nd the recorded time in the \R\ object and the 3rd column describes the missing component.
}
\item{names}{
names of all variables in the catalogue list object.
}}
\seealso{
\code{\link{as.catalogue}}, \code{\link{summary}}
}
\examples{
data(NZ55)
summary(NZ55)
}

\keyword{methods}
