\name{summary.subset}
\alias{summary.subset}
\title{
Summary of Subset
}
\description{
This function provides a method for the generic function \code{\link{summary}} for objects of class \code{"subset"}.
}
\usage{
\method{summary}{subset}(object, plot=FALSE, ...)
}
\arguments{
\item{object}{
an object of class \code{"subset"}.
}
\item{plot}{
logical. Default is \code{FALSE}, in which case the character string is composed of only ASCII characters. If \code{TRUE} it is composed so that inequalities are represented properly on a graphics device.
}
\item{\dots}{
other options for summarising \code{"subset"} objects.
}
}
\value{
One character string describing the subset represented by \code{object}.
}
\seealso{
\code{\link{subset.circle}}, \code{\link{subset.polygon}}, \code{\link{subset.rect}}, \code{\link{subset.sphere}}, \code{\link{print.subset}}
}
\examples{
data(NZ55)
a <- subsetrect(NZ55, minlong=165, maxlong=180, minlat=-48, maxlat=-35,
                 minmag=7, minday=julian(2,27,1960)+12/24+32/1440)
summary(a)
}

\keyword{methods}
