\name{write.catalogue}
\alias{write.catalogue}
\title{
Write Catalogue to a Text File
}
\description{
Writes an earthquake catalogue within the library to an ASCII file.
}
\usage{
write.catalogue(x, file=paste(deparse(substitute(x)), ".txt", sep = ""),
                ignore=FALSE, append=FALSE)
}
\arguments{
\item{x}{
name of the earthquake catalogue.
}
\item{file}{
required name of the ASCII file. By default, it will have the same name as the catalogue with \dQuote{.txt} appended.
}
\item{ignore}{
if \code{TRUE}, do not print negative signs on latitudes. Default is \code{FALSE}.
}
\item{append}{
if \code{TRUE} and the ASCII file already exists, the catalogue will be appended to the end of the file, otherwise the contents of the file are overwritten. Default is \code{FALSE}.
}}
\value{
\code{NULL}
}
\section{Side Effects}{
Writes an ASCII file as described above.
}

\examples{
data(NZ55)
write.catalogue(NZ55, file="temp.txt")
}

\keyword{IO}
