"bvalue.contour" <-
function (events, divs = c(15, 15, 15), h = c(0.5, 0.5, 15), 
          threshold = 30, depth = 10) 
{
    as.catalogue(events, "data")
    widths <- c(events$maxlong - events$minlong, events$maxlat - 
        events$minlat, events$maxdepth - events$mindepth)
    kmdist <- c((widths[1] * cos((events$maxlat + events$minlat)/2/180 * 
        pi) * pi)/180 * 6371, widths[2]/180 * pi * 6371)
    boxdim <- widths/divs
    n <- 0
    store <- matrix(rep(0, (divs[1] + 1) * (divs[2] + 1) * (divs[3] + 
        1) * 4), ncol = 4)
    ddl <- data$longitude
    dda <- data$latitude
    ddd <- data$depth
    ddm <- data$magnitude
    imdsq <- matrix(-1, ncol = divs[1] + 1, nrow = length(ddm))
    jmdsq <- matrix(-1, ncol = divs[2] + 1, nrow = length(ddm))
    for (k in seq(events$mindepth, events$maxdepth, len = divs[3] + 
        1)) {
        boxheight <- c(k - boxdim[3], k + boxdim[3])
        kcondition <- ddd >= boxheight[1] & ddd <= boxheight[2]
        kmdsq <- (k - ddd)^2
        iseq <- 0
        for (i in seq(events$minlong, events$maxlong, length = divs[1] + 
            1)) {
            iseq <- iseq + 1
            boxlength <- c(i - boxdim[1], i + boxdim[1])
            jcondition <- kcondition & ddl >= boxlength[1] & 
                ddl <= boxlength[2]
            if (imdsq[1, iseq] < 0) 
                imdsq[, iseq] <- (kmdist[1]/widths[1] * (i - 
                  ddl))^2
            jseq <- 0
            for (j in seq(events$minlat, events$maxlat, length = divs[2] + 
                1)) {
                jseq <- jseq + 1
                boxwidth <- c(j - boxdim[2], j + boxdim[2])
                condition <- jcondition & dda >= boxwidth[1] & 
                  dda <= boxwidth[2]
                if (sum(condition) >= threshold) {
                  magnitudes <- ddm[condition]
                }
                else {
                  if (jmdsq[1, jseq] < 0) 
                    jmdsq[, jseq] <- (kmdist[2]/widths[2] * (j - 
                      dda))^2
                  distances <- imdsq[, iseq] + jmdsq[, jseq] + 
                    kmdsq
                  positions <- order(distances)
                  magnitudes <- (ddm[positions])[1:threshold]
                }
                beta <- length(magnitudes)/((log(10)) * (sum(magnitudes - 
                  min(magnitudes))))
                n <- n + 1
                store[n, ] <- c(i, j, k, beta)
            }
        }
    }
    X1 <- store[, 1]
    X2 <- store[, 2]
    X3 <- store[, 3] - depth
    X3term <- X3^2/(2 * h[3]^2)
    Y <- store[, 4]
    N <- length(X1)
    dim(Y) <- c(1, N)
    tY <- t(Y)
    numgrid <- 30
    mx <- c(1:numgrid^2)
    dim(mx) <- c(numgrid, numgrid)
    bfe <- c(1, 0, 0, 0)
    dim(bfe) <- c(1, 4)
    counterx1 <- 1
    counterx2 <- 1
    const <- ((2 * pi)^(1.5) * h[1] * h[2] * h[3])^(-1)
    for (x1s in seq(events$minlong, events$maxlong, length = numgrid)) {
        X1mx1s <- X1 - x1s
        X1term <- X1mx1s^2/(2 * h[1]^2)
        for (x2s in seq(events$minlat, events$maxlat, length = numgrid)) {
            X2mx2s <- X2 - x2s
            bfX <- cbind(rep(1, N), X1mx1s, X2mx2s, X3)
            W <- const * exp(-X1term - (X2mx2s)^2/(2 * h[2]^2) - 
                X3term)
            bfXTW <- rbind(W, X1mx1s * W, X2mx2s * W, X3 * W)
            inverse <- solve(bfXTW %*% bfX)
            mx[counterx1, counterx2] <- (inverse %*% (bfXTW %*% 
                tY))[1]
            counterx2 <- counterx2 + 1
        }
        counterx2 <- 1
        counterx1 <- counterx1 + 1
    }
    x <- seq(events$minlong, events$maxlong, len = numgrid)
    y <- seq(events$minlat, events$maxlat, len = numgrid)
    contour(x, y, mx, nlevels = 9, xlab = "Longitude",
            ylab = "Latitude", labcex = 1, 
            main = paste("b-Value Contours: At", depth, "km Depth"))
}
