"depth.hist" <-
function(events, cumulative = FALSE, delta = NA)
{
#________________________________________________________________________
#     Plots a histogram of the depth of selected events.
#________________________________________________________________________
	depth <- eval(parse(text = events$catname))$depth[events$indices]
	if(events$maxdepth == 1/0)
		maxdepth <- max(depth, na.rm = TRUE)
	else maxdepth <- events$maxdepth
	if(is.na(delta)) {
		if(maxdepth - events$mindepth > 110)
			delta <- 10
		else delta <- 1
	}
	mindepth <- delta * floor(events$mindepth/delta)
	maxdepth <- delta * ceiling(maxdepth/delta)
	widths <- seq((mindepth), (maxdepth + delta), delta)
	temp1 <- hist(depth, plot = FALSE, breaks = widths)
	if(cumulative == TRUE) {
		ylimits <- c(0, 1)
		label <- "Cumulative Probability Distribution"
		temp1$counts <- cumsum(temp1$intensities) * delta
	}
	else {
		ylimits <- c(0, 1.05*max(temp1$counts, na.rm = TRUE))
		label <- "Number of Events"
	}
	barplot(temp1$counts, xlab = "Depth (km)", ylab = label, ylim = ylimits,
		width = diff(widths), space = 0, col = 2)
	end <- sum(par("usr")[1:2]) - 1
	at <- pretty(seq(0, end) + mindepth, n = 7)
	if(at[1] < mindepth) at <- at[-1]
	lat <- length(at)
	if(at[lat] > (maxdepth)) at <- at[-lat]
	axis(1, at = at-mindepth, labels = as.character(at))
	box()
	invisible()
}
