"dkagan" <-
function(M, alpha = 1, beta = 0, gamma = 7, M0 = 4, mag = TRUE, theta = 0.75,
	 phi = 2.4)
{
   #converts magnitudes to stress if mag = true, then computes density of Kagan
  # distribution as in "Remarks on AMR Model" by Yang, Robinson and DVJ. Note
  # default parameters are in magnitudes
  L <- magnitude.convert(beta, theta, phi)
  U <- magnitude.convert(gamma, theta, phi)
  x0 <- magnitude.convert(M0, theta, phi)
  rho <- (x0 + L)/U
  if(mag)
  {    
    xM <- magnitude.convert(M, theta, phi)
    v <- (xM + L)/(x0 + L)
    dV <- (alpha + rho*v)*v^(-(alpha + 1))*exp(-rho*(v - 1))
    theta1 <- log(10)*theta
    dx <- (xM/(x0 + L))*dV*theta1
  } else   {
    v <- (M + L)/(x0 + L)
    dV <- (alpha + rho*v)*v^(-(alpha + 1))*exp(-rho*(v - 1))
    theta1 <- log(10)*theta
    dx <- (M/(x0 + L))*dV*theta1          
  }
  return(dx)
}
