"epicentres" <-
function (events, usr = NA, magnitude = c(-Inf, Inf), cex = NA, 
    criteria = TRUE, depth = c(0, Inf), colours = c("red2", "yellow2", 
        "green2", "cyan2", "blue2"), mapname = "world2") 
{
    if (any(class(events) == c("catalogue", "matrix"))) {
        latitude <- events[, "latitude"]
        longitude <- events[, "longitude"]
        event.depth <- events[, "depth"]
        event.mag <- events[, "magnitude"]
    }
    else if (!is.null(class(events))) {
        if (any(class(events) == "subset")) {
            latitude <- eval(parse(text = events$catname))$latitude[events$indices]
            longitude <- eval(parse(text = events$catname))$longitude[events$indices]
            if (!missing(depth)) 
                event.depth <- eval(parse(text = events$catname))$depth[events$indices]
            if (!missing(magnitude)) 
                event.mag <- eval(parse(text = events$catname))$magnitude[events$indices]
        }
        else stop("events object should have class `subset'")
    }
    else stop("events object should have class `subset' or mode `matrix'")
    if (length(usr) != 4) 
        usr <- c(range(longitude), range(latitude)) + c(-0.01, 
            0.01, -0.01, 0.01)
    colours <- c("black", "gray35", colours)
    map1(mapname, usr, axes = TRUE, reset = FALSE, col = "gray35")
    if (any(is.na(cex))) 
        cex <- seq(0.2, (length(magnitude) - 1), 0.5)
    for (j in seq(2, length(magnitude))) {
        for (k in seq(length(depth), 2, -1)) {
            a <- rep(TRUE, length(latitude))
            if (!missing(depth)) 
                a <- event.depth >= depth[k - 1] & event.depth < 
                  depth[k]
            if (!missing(magnitude)) 
                a <- a & event.mag >= magnitude[j - 1] & event.mag < 
                  magnitude[j]
            if (length(magnitude) == 2) 
                points(longitude[a], latitude[a], cex = cex[j - 
                  1], col = colours[k + 1])
            else points(longitude[a], latitude[a], cex = cex[j - 
                1], col = colours[k + 1], lwd = cex[j - 1], pch = 1)
        }
    }
    if (!is.null(class(events))) 
        if (criteria == TRUE & any(class(events) == "subset")) 
            mtext(text = summary(events, plot = TRUE), cex = 0.4, 
                side = 1, outer = FALSE, line = 2.5, adj = 0.5)
    invisible()
}
