"epicentres.identify" <-
function (events, mapname = "world2", criteria = TRUE) 
{
    if (!is.null(class(events))) {
        if (any(class(events) == "subset")) {
            latitude <- eval(parse(text = events$catname))$latitude[events$indices]
            longitude <- eval(parse(text = events$catname))$longitude[events$indices]
            event.mag <- eval(parse(text = events$catname))$magnitude[events$indices]
        }
        else stop("events object should have class `subset'")
    }
    else stop("events object should have class `subset'")
    std.latitude <- sqrt(var(latitude))
    std.longitude <- sqrt(var(longitude))
    z.latitude <- abs((latitude - mean(latitude))/std.latitude)
    z.longitude <- abs((longitude - mean(longitude))/std.longitude)

    map(mapname, xlim=range(longitude) + c(-.1, .1)*std.longitude,
	ylim=range(latitude) + c(-.1, .1)*std.latitude)
    axis(1, cex.axis = 0.7, las = 1)
    axis(2, cex.axis = 0.7, las = 1, srt = 90)
    box()
    points(longitude, latitude, pch = ".", col = 2)
    a <- z.latitude > 6 | z.longitude > 6
    points(longitude[a], latitude[a], cex = (z.latitude[a] + 1) *
	(z.longitude[a] + 1)/5, col = 2)
    outliers <- identify(longitude, latitude)
    if (criteria == TRUE & any(class(events) == "subset")) 
        mtext(text = summary(events, plot = TRUE), cex = 0.4, 
            side = 1, outer = FALSE, line = 2.5, adj = 0.5)
    return(events$indices[outliers])
}
