"est.kagan" <-
function(Data, alpha = 1, beta = 0, gamma = 7, theta = 0.75, phi = 2.4,
 	 tol = 10^-3, Mag = TRUE, deltam = 2)
{  
# Estimates parameters in Kagan distribution.  Data is given in magnitudes
# or moments. Parameter estimates must be given as magnitude equivalents 
# where relevant.

  "lbeta" <- function(v1, tol1 = tol)
  {
    # calculates rho, alpha in reduced form of likelihood equation
    A <- mean(log(v1))
    B <- mean(v1 - 1)
    rhomax <- 1/(max(B - A*v1)) 
    d <- B - A*v1
    rho <- 0.9*rhomax
    delta <- 0.05*rhomax
    i <- 0
    while(abs(delta) > tol1*rho && i<100)
    {
      i <- i + 1                                
      func <- mean(d/(1 - rho*d))
      deriv <- mean((d/(1 - rho*d))^2)
      delta1 <- -func/deriv 
      delta <- sign(delta1)*min(rho/2, abs(delta1), (rhomax - rho)/2)      
      rho <- rho + delta
    }
    alpha <- (1 - rho*B)/A
    barlogl <- -(alpha + 1)*A - rho*B + mean(log(alpha + rho*v1))             
    vgam <- 1/rho 
    return(c(rho, alpha, vgam, barlogl, i))
  }

  "lgam" <- function(v1, tol1 = .001, alpha = 1)
  {    
    #calculates rho with alpha given
    B <- mean(v1 - 1)
    A <- mean(log(v1))
    rho <- min(.01, 1/B)
    y <- 0
    i <- 0
    while(abs(rho - y) > tol1*rho)  
    {
      i <- i + 1
      y <- rho
      rho <- (1 - alpha*mean(1/(alpha + rho*v1)))/B
      # print(rho)
      }
    barlogl <- -(alpha + 1)*A - rho*B + mean(log(alpha + rho*v1))             
    vgam <- 1/rho
    return(c(rho, alpha, vgam, barlogl, i))
  }

  "lalph" <- function(v1, tol1 = .001, rho = .03)
  {    
    # calculates alpha for gamma given.
    B <- mean(v1 - 1)
    A <- mean(log(v1))
    alpha <- max(1/A, 1)
    y <- 0
    i <- 0
    while(abs(alpha - y) > tol1*rho)  
    {
      i <- i + 1
      y <- alpha
      alpha <- (1 - rho*mean(v1/(alpha + rho*v1)))/A
      # print(rho)
    }
    barlogl <- -(alpha + 1)*A -rho*B + mean(log(alpha + rho*v1))             
    vgam <- 1/rho
    return(c(rho, alpha, vgam, barlogl, i))
  }
  # converts initial data to moments   
   
  if (Mag)
  {
    s <- 10^(theta*Data + phi)
  }  else {
    s <- Data
  }
  s0 <- min(s)                 
  M0 <- (log10(s0) - phi)/theta
  nrow <- deltam/0.05*2

  if(is.na(alpha) & is.na(beta) & is.na(gamma))
  { 
    # all parameters unknown: finds maximum by scanning over beta
    ests <- matrix(data = rep(10^-10, 6*nrow), ncol = 6, nrow = nrow)  
    for(k in 1:nrow) 
    {
      betarep <-  M0 - deltam + .05*k
      Lrep <- 10^(betarep*theta + phi)
      vrep <- (s + Lrep)/(s0 + Lrep)
                     
      ests[k, ] <- c(lbeta(v1 = vrep, tol1 = tol), Lrep) 
    }
    barlogl <- ests[, 4] - log(s0 + ests[, 6])
    nn <- match(max(barlogl, na.rm = TRUE), barlogl)                 
    rhoest <- (ests[nn, ])
    L <- rhoest[6]
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    beta <- (log10(L) - phi)/theta
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(barlogl[nn])
    return(cbind(alpha, beta, gamma, M0, loglik))
  }

  if(is.na(alpha) & !is.na(beta) & is.na(gamma))
  {
    # estimates alpha and gamma if beta given
    L <- 10^(beta*theta + phi)
    v <- (s + L)/(s0 + L)
    rhoest <- lbeta(v, tol1 = tol)
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(rhoest[4] - log(s0 + L)) 
    return(cbind(alpha, beta, gamma, M0, loglik))
  }
  
  if(!is.na(alpha) & is.na(beta) & is.na(gamma))       
  {
    # scans over beta with alpha fixed, gamma unknown 
    ests <- matrix(data = rep(10^-10, 6*nrow), ncol = 6, nrow = nrow)  
    for(k in 1:nrow) 
    {
      betarep <- M0 - deltam + .05*k
      Lrep <- 10^(betarep*theta + phi)
      vrep <- (s + Lrep)/(s0 + Lrep)
      ests[k, ] <- c(lgam(v1 = vrep, tol1 = tol, alpha = alpha), Lrep) 
    }
    barlogl <- ests[, 4] - log(s0 + ests[, 6])
    nn <- match(max(barlogl, na.rm = TRUE), barlogl)
    rhoest <- (ests[nn, ])
    L <- rhoest[6]
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    beta <- (log10(L) - phi)/theta
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(barlogl[nn])
    return(cbind(alpha, beta, gamma, M0, loglik))
  }
  
  if(is.na(alpha) & is.na(beta) & !is.na(gamma))
  {
    # estimates beta by scanning and alpha, given gamma
    U <- 10^(gamma*theta + phi)
    ests <- matrix(data = rep(10^-10, 6*nrow), ncol = 6, nrow = nrow)  
    for(k in 1:nrow) 
    {
      betarep <- M0 - deltam + .05*k
      Lrep <- 10^(betarep*theta + phi)
			
      vrep <- (s + Lrep)/(s0 + Lrep)
      rhorep <- (s0 + Lrep)/U
      ests[k, ] <- c(lalph(v1 = vrep, tol1 = tol, rho = rhorep), Lrep) 
    }
    barlogl <- ests[, 4] - log(s0 + ests[, 6])
    nn <- match(max(barlogl, na.rm = TRUE), barlogl)  
    rhoest <- (ests[nn, ])
    L <- rhoest[6]
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    beta <- (log10(L) - phi)/theta
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(barlogl[nn])
    return(cbind(alpha, beta, gamma, M0, loglik))
  }     

  if(!is.na(alpha) & !is.na(beta) & is.na(gamma))
  {
    # estimates gamma if alpha and beta given
    L <- 10^(beta*theta + phi)
    v <- (s + L)/(s0 + L)
    rhoest <- lgam(v, tol1 = tol, alpha = alpha)
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(rhoest[4] - log(s0 + L)) 
    return(cbind(alpha, beta, gamma, M0, loglik))
  }

  if(is.na(alpha) & !is.na(beta) & !is.na(gamma))
  {
    # estimates alpha, the other two being fixed
    L <- 10^(beta*theta + phi)
    v <- (s + L)/(s0 + L)
    U <- 10^(gamma*theta + phi)
    rho <- (s0 + L)/U
    rhoest <- lalph(v, tol1 = tol, rho = rho)
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(rhoest[4] - log(s0 + L)) 
    return(cbind(alpha, beta, gamma, M0, loglik))
  }
                     
  if(!is.na(alpha) & is.na(beta) & !is.na(gamma))
  {
    # estimates beta by scanning 
    U <- 10^(gamma*theta + phi)
    ests <- matrix(data = rep(10^-10, 6*nrow), ncol = 6, nrow = nrow)  
    for(k in 1:nrow) 
    {
      betarep <- M0 - deltam + .05*k
      Lrep <- 10^(betarep*theta + phi)
      vrep <- (s + Lrep)/(s0 + Lrep)
      rhorep <- (s0 + Lrep)/U 
      vgam <- 1/rhorep
	A <- mean(log(vrep))	
	B <- mean(vrep - 1)
        barlogl <- -(alpha + 1)*A - rhorep*B + mean(log(alpha + rhorep*vrep)) 
        ests[k, ] <- c(rhorep, alpha, 1/rhorep, barlogl, 1, Lrep) 
    }
    barlogl <- ests[, 4] - log(s0 + ests[, 6])
    nn <- match(max(barlogl, na.rm = TRUE), barlogl)                  
    rhoest <- (ests[nn, ])
    L <- rhoest[6]
    alpha <- rhoest[2]
    U <- rhoest[3]*(s0 + L)
    beta <- (log10(L) - phi)/theta
    gamma <- (log10(U) - phi)/theta
    loglik <- length(s)*(barlogl[nn])
    return(cbind(alpha, beta, gamma, M0, loglik))
  } else {
    return(cbind(alpha, beta, gamma))
  }
}
