"findlast" <-
function(upper, x)
{
#________________________________________________________________________
#     upper is a vector of upper bounds, x is a sorted array of numbers.
#     Returns a vector of the same length as lower, containing the largest
#     index of x such that x[index[i]] <= upper[i], 
#                                 for i = 1, ... , length(upper).
#________________________________________________________________________
	temp <- NULL
	for(i in 1:length(upper)) {
		n <- length(seq(1, length(upper))[x <= upper[i]])
		temp[i] <- seq(1, length(x))[x <= upper[i]][n]
	}
	return(temp)
}
