"freq.cusum" <-
function(events, delta = 1, trainyears = 7)
{
#________________________________________________________________________
#     Draws a cusum of event frequencies over time. The target value is
#     the estimated mean frequency in the training period.
#________________________________________________________________________
	catname <- parse(text = events$catname)
	if(events$minday !=  - Inf)
		begin <- years1(events$minday)
	else begin <- month.day.year(min(eval(catname)$time[events$indices], 
			na.rm = TRUE))$year
	if(events$maxday != Inf)
		finish <- years1(events$maxday)
	else finish <- month.day.year(max(eval(catname)$time[events$indices], 
			na.rm = TRUE))$year
	period <- c(begin, finish)
	per <- (period - begin) * 12
	#  '-begin' turns 'period' into starting at zero, and into months.
	per[2] <- per[2] + 12	
	#  'per' is only 2 in length - '+12' is so the last year can 
	#  have some duration
	trainperiod <- c(finish - trainyears + 1, finish)
	train <- (trainperiod - begin) * 12
	train[2] <- train[2] + 12
	que <- years1(eval(catname)$time[events$indices])
	q1 <- (que - begin) * 12 + months1(eval(catname)$time[events$indices])
	# 'minus begin' makes it time zero at starting point, '*12' turns years to 
	# months, and then months are added on the years.
	p1 <- hist(q1, breaks = seq(per[1], per[2], delta), plot = FALSE)
	n1 <- firstlast(train[1], train[2], p1$breaks)[1]
	n2 <- firstlast(train[1], train[2], p1$breaks)[2] - 1
	meannumber <- mean(p1$counts[n1:n2])	
	#	deviations <- p1$counts[1:(n1 - 1)] - meannumber
	deviations <- p1$counts - meannumber
	cusumdeviations <- rev(cumsum(rev(deviations)))
	xlab <- paste("Months From January ", begin, "  (Training Period:  ", 
		trainperiod[1], ".01 - ", trainperiod[2], ".12)", sep = "")
	plot(seq(0, per[2] - delta, delta), cusumdeviations, type = "l", ylab
		 = "Frequency Cusum from Mean", xlab = xlab)
	abline(0, 0, lty = 3)
	abline(v = train[1] - 0.5)
	axis(3, at = seq(0, finish - begin + 1) * 12, lab = paste("Jan",
		formatC((seq(begin, finish + 1))%%100, width=2, flag="0"),
                sep = ""))
}
