"freq.magnitude" <-
function(events, delta = 0.1, bvalue = NA, estimate = "ml", plot = TRUE)
{
#________________________________________________________________________
#     Frequency-magnitude plot of the selected events.
#________________________________________________________________________
        magnitude <- eval(parse(text = events$catname))$magnitude[events$indices]
	minmag <- min(magnitude, na.rm = TRUE)
	temp1 <- hist(magnitude, plot = FALSE, breaks = seq((minmag
		- delta/2), (max(magnitude, na.rm = TRUE) + delta), delta))
	n <- length(temp1$intensities)
	temp1$intensities <- log10(1 - cumsum(temp1$intensities[1:(n - 1)])*delta)
	x <- seq(minmag, max(
		magnitude, na.rm = TRUE), delta)[1:(n - 1)]
	if (plot) {
		plot(x, temp1$intensities, xlab = "m", ylab = "")
		title(ylab = expression(paste(log[10], "(Proportion of Events with Magnitude > m)")))
	}
	if(!is.na(bvalue)){
		if (plot) abline(minmag * bvalue,  -bvalue, lty = 3)
	} else {
		if (estimate == "ls"){
			leastsq <- lsfit(x, temp1$intensities)
			bvalue <- -leastsq$coef[2]
			if (plot) abline(leastsq$coef[1], -bvalue, lty = 3)
		} else {
			bvalue <- 1/(log(10)*mean(magnitude - minmag, na.rm = TRUE))
			if (plot) abline(minmag * bvalue, -bvalue, lty = 3)
		}
	}
	if (plot) box()
        invisible(bvalue)
}
