"hemisphere" <-
function(longitude, latitude, plot.title = "Azimuths Projection")
{
#_______________________________________________________________
#     Projects a hemisphere of the world map centred at
#     the coordinates (longitude, latitude).
#_______________________________________________________________
  if (!exists("worldLores", mode="list")) data("worldLores",
    package="ssEDA")
  temp <- projection(1, worldLores$latitude, worldLores$longitude, 
    longitude, latitude)
  temp$x[temp$z <= 0] <- NA
  temp$y[temp$z <= 0] <- NA
  plot(temp$x, temp$y, type = "l", xlim = c(-1, 1), ylim = c(-1, 1),
    axes = FALSE, xlab = "", ylab = "")
  lines(sin((c(0:360) * pi)/180), cos((c(0:360) * pi)/180))
  title(main = plot.title)
  title(sub = paste("Reference Point:", longitude, "deg longitude  ", 
    latitude, "deg latitude"), cex.sub = 0.6)
}
