"magnitude.contour" <-
function(events, h = c(0.3, 0.2, 10), depth = 10)
{
    as.catalogue(events, "data")
    X1 <- data$longitude
    X2 <- data$latitude
    X3 <- data$depth
    Y <- data$magnitude
    N <- length(X1)
    dim(Y) <- c(1, N)
    numgrid <- 30
    mx <- c(1:numgrid^2)
    dim(mx) <- c(numgrid, numgrid)
    bfe <- c(1, 0, 0, 0)
    dim(bfe) <- c(1, 4)
    counterx1 <- 1
    counterx2 <- 1
    bfXTW <- 1:(4 * N)
    dim(bfXTW) <- c(4, N)
    for(x1s in seq(events$minlong, events$maxlong, length = numgrid)) {
	for(x2s in seq(events$minlat, events$maxlat, length = numgrid)
	    ) {
	    bfX <- c(rep(1, times = N), X1 - x1s, X2 - x2s, X3 - 
		depth)
	    dim(bfX) <- c(N, 4)
	    W <- ((2 * pi)^(1.5) * h[1] * h[2] * h[3])^(-1) * exp( - (
		X1 - x1s)^2/(2 * h[1]^2) - (X2 - x2s)^2/(2 * h[
		2]^2) - (X3 - depth)^2/(2 * h[3]^2))
	    bfXTW[1,  ] <- W
	    bfXTW[2,  ] <- bfX[, 2] * W
	    bfXTW[3,  ] <- bfX[, 3] * W
	    bfXTW[4,  ] <- bfX[, 4] * W
	    inverse <- solve(bfXTW %*% bfX)
	    mx[counterx1, counterx2] <- bfe %*% inverse %*% (bfXTW %*% 
		t(Y))
	    counterx2 <- counterx2 + 1
	    W <- 0
	    bfX - 0
	    inverse <- 0
	}
	counterx2 <- 1
	counterx1 <- counterx1 + 1
    }
    x <- seq(events$minlong, events$maxlong, len = numgrid)
    y <- seq(events$minlat, events$maxlat, len = numgrid)
    contour(x, y, mx, nlevels = 10, xlab = "Longitude",
            ylab = "Latitude", labcex = 1,
            main = paste("Magnitude Contours: At", depth, "km Depth"))
}
