"magnitude.cusum" <-
function(events, trainyears = 7, at.breaks = NA)
{
#________________________________________________________________________
#     Draws a cusum of event magnitudes over time. The target value is
#     the estimated mean magnitude in the training period.
#________________________________________________________________________
	catname <- parse(text = events$catname)
	if(events$minday !=  - Inf)
                begin <- years1(events$minday)   
	else begin <- month.day.year(min(eval(catname)$time[events$indices],
			na.rm = TRUE))$year
	finish <- month.day.year(max(eval(catname)$time[events$indices],
			na.rm = TRUE))$year
	trainperiod <- c(finish - trainyears + 1, 1, finish, 12)
	if(is.na(at.breaks))
		at.breaks <- seq(begin, finish, 1)
	magnitude <- eval(catname)$magnitude[events$indices]
        year <- years1(eval(catname)$time[events$indices])
	month <- as.numeric(months1(eval(catname)$time[events$indices]))
	ym <- year + month/100
	tn1 <- findfirst(trainperiod[1] + trainperiod[2]/100, ym)
	tn2 <- findlast(trainperiod[3] + trainperiod[4]/100, ym)
	meanmagnitude <- mean(magnitude[tn1:tn2])
	deviations <- magnitude - meanmagnitude
	cusumdeviations <- rev(cumsum(rev(deviations)))
	xlab <- paste("Event Sequence Number  (Training Period:  ", 
		as.character(trainperiod[1] + trainperiod[2]/100), " - ", 
		as.character(trainperiod[3] + trainperiod[4]/100), ")", sep = 
		"")
	ylab <- "Magnitude Cusum from Mean"
	plot.ts(cusumdeviations, type = "l", ylab = ylab, xlab = xlab)
	abline(0, 0, lty = 3)
	axis(3, at = findfirst(at.breaks, year), lab = paste("Jan",
		formatC(at.breaks%%100, width=2, flag="0"), sep = ""))
	abline(v = findfirst(at.breaks, year), lty = 2)
	abline(v = tn1 - 0.5)
	invisible()
}
