"magnitude.time" <-
function(events)
{
	catname <- parse(text = events$catname)
	magnitude <- eval(catname)$magnitude[events$indices]
	if(events$minday == - Inf) {
		yrmin <- as.numeric(month.day.year(min(eval(catname)$time[
			events$indices]))$year)
		minday <- datetimes(year = yrmin, month = 1, day = 1, hour = 
			0, minute = 0, second = 0)
		class(minday) <- "datetimes"
	}
	else minday <- events$minday
	if(events$maxday == Inf) {
		yrmax <- as.numeric(month.day.year(max(eval(catname)$time[
			events$indices]))$year)
		maxday <- julian(12, 31, yrmax)
	}
	else maxday <- events$maxday
	xlim <- c(as.numeric(minday), as.numeric(maxday))
	origin <- attr(eval(catname)$time[events$indices], "origin")
	origin.dt <- julian(origin[1], origin[2], origin[3])
	days <- eval(catname)$time[events$indices] + (origin.dt - minday)
	label <- month.day.year(xlim[1])
	plot(days, magnitude, type = "h", xlab = paste("Days Since", format(
		minday)), ylab = "Event Magnitude", xlim = c(0, (xlim[2] - 
		xlim[1])), ylim = range(magnitude) + c(-1/2, 1/2))
	invisible()
}
