"map1" <-
function (mapname, usr, axes=TRUE, reset=TRUE, col="gray35")
{
    #    Draw map with rectangular projection
    plot.new()
    par.reset <- par(no.readonly=TRUE)
    #   Margin Sizes
    mai <- par()$mai
    #  Aspect is y/x of area within axes
    aspect <- (usr[4] - usr[3])/(usr[2] - usr[1])/cos(((usr[3] + 
               usr[4])/2 * pi)/180)
    #  pin is the area within the axes
    pin <- par()$pin
    if (pin[2]/pin[1] > aspect) pin[2] <- aspect*pin[1]
    else pin[1] <- pin[2]/aspect
    #    Set figure area (fin)
    fin <- c(pin[1]+mai[2]+mai[4], pin[2]+mai[1]+mai[3])
    par(fin=fin, pin=pin, usr=usr)
    map(mapname, add=TRUE, interior=FALSE, col=col,
        xlim=c(usr[1], usr[2]), ylim=c(usr[3], usr[4]))
    if (axes){
        axis(1)
        axis(2)
        box()
    }
    if (reset) par(par.reset)
}

