"multigraph" <-
function(events, plots, ncols = 1, title = "", criteria = TRUE)
{
#________________________________________________________________________
#     Graph of multiple plots of events satisfying selection criteria.
#________________________________________________________________________
        par.sav <- par(mfrow = c(ceiling(length(plots)/ncols), ncols), 
		oma = c(1.5 * criteria, 0, 3.5 * (
                title != ""), 0), mar = c(5.1, 4.1, 2.1, 2.1))
        for(k in 1:length(plots)) {
                plots[[k]](events)
        #     using call() and eval() uses an excessive amount of time
        }
	if (criteria)
		mtext(summary(events, plot = TRUE), cex = 0.5, side = 1, outer = TRUE)
	if (title != "")
		mtext(title, side = 3, outer = TRUE, cex = 1.4)
	par(par.sav)
}
