"pkagan" <-
function(M, alpha = 1, beta = 0, gamma = 7, M0 = 4, mag = TRUE, theta = 0.75,
	 phi = 2.4)
{
  # converts magnitudes to stress if mag = true, then computes cdf of Kagan
  # distribution as in "Remarks on AMR Model" by Yang, Robinson and DVJ. Note
  # beta, gamma and M0 are all in magnitudes.
  #
  L <- magnitude.convert(beta, theta, phi)
  U <- magnitude.convert(gamma, theta, phi)
  x0 <- magnitude.convert(M0, theta, phi)
  rho <- (x0 + L)/U
  if(mag) 
  {   
    xM <- magnitude.convert(M, theta, phi)
    v <- (xM + L)/(x0 + L)
  } else {          
    v <- (M + L)/(x0 + L)
  }
  p <- 1 - v^(-alpha)*exp(-rho*(v - 1))
  return(p)
}
