"qkagan" <-
function(p, alpha = 1, beta = 0, gamma = 7, M0 = 4, mag = TRUE, theta = 0.75,
	 phi = 2.4)
{
  # If mag = true, converts magnitudes to stresses, then uses Newton-Raphson
  # to calculate quantiles after reducing to standardised variates.
  L <- magnitude.convert(beta, theta, phi)
  U <- magnitude.convert(gamma, theta, phi)
  x0 <- magnitude.convert(M0, theta, phi)
  rho <- (x0 + L)/U
  if(mag)
  {
     v <- (1 - p)^(-1/alpha)
     for(j in 1:8)
     {
        func <- alpha*log(v) + rho*(v - 1) + log(1 - p)
        deriv <- alpha/v + rho
        delta <- -func/deriv
        v <- v + delta
        i <- j
      }
      M <- magnitude.convert((x0 + L)*v - L, inverse = TRUE)
      return(M)
  } else {
    v <- (1 - p)^( -1/alpha)
    for(j in 1:8)
    {
      func <- alpha*log(v) + rho*(v - 1) + log(1 - p)
      deriv <- alpha/v + rho
      delta <- -func/deriv
      v <- v + delta
      i <- j
    }
    x <- (x0 + L)*v - L
    return(x)
  }
}
