"rkagan" <-
function(n, alpha = 1, beta = 0, gamma = 7, M0 = 4, mag = TRUE, theta = 0.75,
	 phi = 2.4)
{
  # computes random variates
  #from  base form  of Kagan distribution then rescales or converts to
  #magnitudes as in "Remarks on AMR Model" by Yang, Robinson
  #and DVJ. Results returned as magnitudes if mag = true.	
  L <- magnitude.convert(beta, theta, phi)
  U <- magnitude.convert(gamma, theta, phi)
  x0 <- magnitude.convert(M0, theta, phi)
  rho <- (x0 + L)/U
  U1 <- runif(n)
  U2 <- runif(n)
  X <-  U1^(-1/alpha) 
  Y <-  1 - log(U2)/rho
  V <- pmin(X, Y)
  SM <- V*(x0 + L) - L
  if(mag)  { 
    Mag <- magnitude.convert(SM, inverse = TRUE)
    return(Mag)
   } else {   
     return(SM)
   }
}
