"rotation" <-
function(events, theta = 0, km = TRUE, criteria = TRUE)
{
	a <- events$indices
	catalogue <- eval(parse(text = events$catname))
	if(km == TRUE) {
		b <- catalogue$latitude[a] * sin(theta/180 * pi) + catalogue$
			longitude[a] * cos(theta/180 * pi) * cos(sum(range(
			catalogue$latitude[a]))/2/180 * pi)
		b <- b/180 * pi * 6371
		b <- b - (max(b) + min(b))/2
		xlab <- "Distance (km)"
	}
	else {
		b <- catalogue$latitude[a] * sin(theta/180 * pi) + catalogue$
			longitude[a] * cos(theta/180 * pi)
                xlab <- substitute(Latitude %*% sin(theta1*degree) +
                          Longitude %*% cos(theta1*degree), list(theta1=theta))
	}
	plot(b,  - catalogue$depth[a], type = "n", ylab = "Depth  (km)", xlab
		 = xlab)
	points(b,  - catalogue$depth[a], cex = 0.2)	
	box()
	if(criteria == TRUE)
		mtext(text = summary(events, plot = TRUE), cex = 0.4,
			side = 1, outer = FALSE, line = 4, adj = 0.5)
	invisible()
}
