threeD <- function (events)
{
    if (!require(rggobi)) {
        cat("\n\n*** threeD() requires the rggobi package ***\n\n")
        return()
    }
    catname <- events$catname
    catalogue <- parse(text = catname)
    datamat <- cbind(eval(catalogue)$longitude[events$indices],
                     eval(catalogue)$latitude[events$indices],
                     -eval(catalogue)$depth[events$indices])
    rownames(datamat) <- as.character(events$indices)
    colnames(datamat) <- c("longitude", "latitude", "depth")
    ggobi(datamat, name = catname)
}

