"timeplot" <-
function(events, yearly = TRUE, smoothline = FALSE, ymax = NA)
{
#________________________________________________________________________
#     Plots a histogram of the number of selected events by time
#     interval, either months or years.
#________________________________________________________________________
	catname <- parse(text = events$catname)
	if(events$minday !=  - Inf)
		begin <- years1(events$minday)
	else begin <- month.day.year(min(eval(catname)$time[events$indices], 
			na.rm = TRUE))$year
	if(events$maxday != Inf)
		finish <- years1(events$maxday)
	else finish <- month.day.year(max(eval(catname)$time[events$indices], 
			na.rm = TRUE))$year
	y3 <- years1(eval(catname)$time[events$indices])
	if(yearly != TRUE) {
		time <- y3 + as.numeric(months1(eval(catname)$time[events$
			indices]))/12
		breaks <- begin - 1/24
		barnames <- NULL
		for(k in begin:finish) {
			breaks <- c(breaks, k + seq(0, 11)/12 + 1/24)
			barnames <- c(barnames, c("1", "", "", "", "", "", "7", 
				"", "", "", "", ""))
		}
		barnames <- as.character(barnames)
		xlab <- "Month"
		smoothx <- breaks[1:(length(breaks) - 1)] + 1/24 - begin
	}
	else {
		time <- y3
		breaks <- seq(begin - 0.5, finish + 0.5, 1)
		xlab <- "Year"
		barnames <- NULL
		smoothx <- seq(0, finish - begin) + 0.5
	}
	temp <- hist(time, breaks = breaks, plot = FALSE)
	if(is.na(ymax))
		ymax <- max(temp$counts)
	barplot(temp$counts, width = diff(temp$breaks), xlab = xlab, ylab
		 = "Number of Events", ylim = c(0, 1.05*ymax), space = 0, col = 2)
	if(smoothline == TRUE)
		lines(supsmu(smoothx, temp$counts), col = 3, lwd = 3)
	# Make up for the lack of histo=TRUE
	end <- sum(par("usr")[1:2]) - 1
	at <- pretty(seq(0, end) + begin, n = 7)
	if(at[1] < begin) at <- at[-1]
	lat <- length(at)
	if(at[lat] > (end+begin)) at <- at[-lat]
	axis(1, at = at-begin+0.5, labels = as.character(at))
	if(!is.null(barnames))
		text(smoothx-begin+1/24, ymax/50, labels = barnames, cex =
		0.5)
	box()
	invisible()
}
