\name{bvalue.contour}
\alias{bvalue.contour}
\title{
b-Value Contours at Specified Depth
}
\description{
This function calculates b-value contours at a pre-specified depth.
}
\usage{
bvalue.contour(events, divs=c(15, 15, 15), h=c(0.5, 0.5, 15),
               threshold=30, depth=10)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{divs}{
a vector of length three. It specifies the grid points where b-values are calculated. The first, second and third entries of this vector correspond to the number of divisions on the longitude, latitude and depth axes respectively.
}
\item{h}{
a vector of length three. This specifies the bandwidths for the kernel function (see Details).
}
\item{threshold}{
the minimum number of events needed to evaluate pointwise b-values (see Details).
}
\item{depth}{
specifies the longitude-latitude plane where the b-value contours are plotted.
}}
\value{
NULL
}
\details{
The b-values are calculated in two steps. First, they are evaluated on a 3D grid using the maximum likelihood method (Utsu, 1965). The MLE estimate at \eqn{(x,y,z)} (corresponds to longitude, latitude and depth respectively) only utilises data that lie in \eqn{S=}\code{(x-divs[1],x+divs[1],y-divs[2],y+divs[2], z-divs[3],z+divs[3])}. However, if the number of points in \eqn{S} is less than that specified by the \code{threshold} parameter, the closest \code{threshold} number of points to \eqn{(x,y,z)} are used. The resulting b-value estimates are smoothed using local linear regression technique described in Ruppert and Wand (1994) using a standard trivariate normal kernel. The smoothness of the contours is controlled by the bandwidths of the kernel.
}

\references{
Ruppert, D. & Wand, M.P. (1994). Multivariate locally weighted least squares regression. \emph{ Ann. Statist.} \bold{22}, 1346--1370.

Utsu, T. (1965). A method for determining the value of \eqn{b} in a formula \eqn{\log n = a - bM}{log n = a - bM} showing the magnitude frequency relation for earthquakes. \emph{Geophys. Bull. Hokkaido University} \bold{13}, 99--103 (in Japanese).
}

\author{Edwin Choi (ANU), 1997}

\seealso{
\code{\link{magnitude.contour}}
}

\examples{
#    This example requires the NZ catalogue

require(ssNZ)

#   Remember the parameters of the graphics device
par.reset <- par(no.readonly=TRUE)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

b <- subsetrect(Wellington, maxdepth=100, minmag=3,
                minlat=-42.2, maxlat=-40.5, minlong=173.6, maxlong=176.0,
                minday=julian(1,1,1980), maxday=julian(1,1,2000))

par(pty="s")
bvalue.contour(b, h=c(0.25, 0.2, 2), depth=10)
map("nz", add=TRUE, col="red")
par(par.reset)
}

\keyword{hplot}

