\name{changes}
\alias{changes}
\title{Changes Made to the Package}
\description{
This page contains a listing of recent changes made to functions, and known general problems.
}

\details{
\enumerate{
\item \code{\link{hemisphere}}: An argument has been added called \code{filename}, with default value \code{"temp.ps"}, giving the name of the postscript file. (February 2003)

\item Function \code{time.plot} has been renamed to \code{\link{timeplot}} to stop confusion with methods and generic functions. (June 2003)

\item \code{\link{hemisphere}}: Argument \code{filename} has been deleted. The plot is now written to the current device or a new window is opened. (June 2003)

\item \code{\link{rotation}}: Argument \code{psname} has been deleted. The plot is now written to the current device or a new window is opened. (June 2003)

\item \code{\link{epicentres}}: Argument \code{mapname} has been added. (July 2003)

\item \code{\link{epicentres.identify}}: Default on argument \code{mapname} has been changed to \code{"world.lores"}. (July 2003)

\item \code{\link{epicentres.identify}}: Changed example in documentation. (October 2003)

\item \code{world.lores} data object renamed to \code{\link{worldLores}} and implemented as \code{.R} form in \code{data/} directory rather than creating \code{.rda} file at install time. (October 2003)

\item \code{world.lores} map name in \code{\link{epicentres.identify}} renamed to \code{\link[maps]{world}} to match \code{maps_2.0-2}. (October 2003)

\item \code{\link{epicentres}}: default value of argument \code{mapname} changed from \code{world2.lores} to \code{\link[maps]{world2}} to match \code{maps_2.0-2}. (November 2003)

\item \code{\link{epicentres.identify}}: default value of argument \code{mapname} changed from \code{world} to \code{\link[maps]{world2}}. (November 2003)

\item Minor documentation formatting changes, mainly to use \code{\\dQuote} and \code{\\pkg}. (January 2004)

\item \code{\link{map1}}: New function. (February 2004)

\item \code{\link{epicentres}}: now calls \code{\link{map1}} to plot map. Is now plotted to the current device, not necessarily a postscript file. Colours are now not defined using the current palette, but explicitly using character strings. (February 2004)

\item \code{\link{worldLores}}, \code{\link{hemisphere}}: Examples modified to make plotting region square. (February 2004)

\item \code{\link{timeplot}}, \code{\link{depth.hist}}: \code{ylim} extended so that tallest bar doesn't touch upper box boundary. (February 2004)

\item \code{texps1}: has been deleted. (February 2004)

\item \code{\link{magnitude.contour}}, \code{\link{bvalue.contour}}: Examples added, now plotted to current device rather than a postscript file. (February 2004)

\item \code{\link{depth.hist}}, \code{\link{freq.cusum}}, \code{\link{magnitude.cusum}}, \code{\link{magnitude.time}}, \code{\link{multigraph}}, \code{\link{plot.subset}}, \code{\link{timeplot}}: The statement \code{if(length(dev.list()) == 0) X11()} has been removed, was required in \acronym{S-PLUS}. (February 2004)

\item \code{\link{epicentres}}: Depth ranges added as a footnote in example plots. (February 2004)

\item \code{\link{map1}}: calls the function \code{\link[maps]{map}}, whose argument \code{color} has been changed to \code{col}. (February 2004)

\item \code{\link{rotation}}: x-axis label changed to make use of degree symbol. (March 2004)

\item \code{\link{bvalue.contour}}, \code{\link{magnitude.contour}}: map added to example plot. (March 2004)

\item \code{\link{worldLores}}: quotes added around package name in code, i.e. \code{"ssEDA"}. (7 May 2004)

\item \code{\link{epicentres}}: function default values in arguments \code{magnitude} and \code{depth} changed from using \code{1/0} to \code{Inf}. (7 May 2004)

\item \code{\link{threeD}}: a statement \code{require(xgobi)} has been added to the code. This requirement is then no longer a \dQuote{package} requirement. (7 May 2004)

\item A statement \code{require(ssNZ)} has been added to the examples that use the NZ catalogue. Hence \pkg{ssNZ} is no longer a \dQuote{package} requirement of \pkg{ssEDA}. (18 May 2004)

\item \code{\link{epicentres}}: code modified so that argument \code{events} can again be a catalogue. (9 Apr 2005)

\item \code{\link{epicentres}}: \code{expression} statement in examples with subtitle containing multiple inequalities changed to make syntactically compatible with recent R updates. (16 Apr 2005)

\item \code{\link{epicentres}}: Reference to \code{postscript} graphics device eliminated from manual page. (21 Apr 2005)

\item \code{\link{worldLores}}: now implemented directly as a \code{data()} call, rather than via \code{delay()}, which has been deprecated. (9 Jun 2005)

\item \code{\link{freq.cusum}}: replace \code{seq(begin, finish + 1) - 1900} with \code{formatC((seq(begin, finish + 1))\%\%100, width=2, flag="0")}. (22 Dec 2005)

\item \code{\link{magnitude.cusum}}: replace \code{at.breaks - 1900} with \code{formatC(at.breaks\%\%100, width=2, flag="0")}. (22 Dec 2005)

\item Package vignettes added. (22 Dec 2005)

\item Fix error in package vignettes. (04 May 2006)

\item \code{\link{depth.hist}}, \code{\link{timeplot}}, \code{\link{freq.magnitude}}: removed redundant arguments in call to \code{\link{hist}} when \code{plot==FALSE}. Caused warning messages. (30 Jan 2007)

\item \code{\link{major}}: new page containing a listing of major earthquake events. (14 May 2007)

\item The \code{if require(catalogue)} syntax in all examples has been changed to \code{require(catalogue)}. (15 May 2007)

\item The \code{DESCRIPTION} file has the following added: \code{Suggests: xgobi, mapdata, ssNZ, ssPDE, ssSCEC}. (05 Jul 2007)

\item All occurences of \code{subset.circle}, \code{subset.polygon}, \code{subset.rect}, \code{subset.sphere} in the Examples have been changed to \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}}, \code{\link[ssBase]{subsetsphere}}. See Changes in \pkg{ssBase}. (8 Nov 2007)

\item \code{\link{threeD}}: modified to use the ggobi utility. See topic \code{\link{threeD}} for installation notes for ggobi. (21 Nov 2007)
}}

\keyword{documentation}
