\name{depth.hist}
\alias{depth.hist}
\title{
Depth Histogram
}
\description{
Plots a histogram of the depth of selected events.
}
\usage{
depth.hist(events, cumulative=FALSE, delta=NA)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.   
}
\item{cumulative}{
boolean value. If \code{TRUE}, the plot is a cumulative histogram. Default if \code{FALSE}.
}
\item{delta}{
numeric, the bar width used in the histogram. By default, if the depth range is greater than 110 km, \code{delta=10}, else \code{delta=1}.
}}
\seealso{
\code{\link{freq.cusum}}, \code{\link{freq.magnitude}},
\code{\link{magnitude.cusum}}, \code{\link{magnitude.time}},
\code{\link{epicentres}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
data(NZ55)

depth.hist(subsetrect(NZ55, minmag=5.5))
}

\keyword{hplot}

