\name{dkagan}
\alias{dkagan}
\alias{pkagan}
\alias{qkagan}
\alias{rkagan}
\title{
Kagan Distribution
}
\description{
Density, cumulative probability, quantiles and random generation for the Kagan distribution.
}
\usage{
dkagan(M, alpha=1, beta=0, gamma=7, M0=4, mag=TRUE, theta=0.75, phi=2.4)
pkagan(M, alpha=1, beta=0, gamma=7, M0=4, mag=TRUE, theta=0.75, phi=2.4)
qkagan(p, alpha=1, beta=0, gamma=7, M0=4, mag=TRUE, theta=0.75, phi=2.4)
rkagan(n, alpha=1, beta=0, gamma=7, M0=4, mag=TRUE, theta=0.75, phi=2.4)
}
\arguments{
\item{p}{
Vector of probabilities.
}
\item{n}{
Non-negative sample size. If \code{length(n)} is greater than 1, then \code{length(n)} random variables are returned.
}
\item{M}{
Vector of quantiles. 
}
\item{alpha}{
Parameter of Kagan distribution. Index of the power law.
}
\item{beta}{
Parameter of Kagan distribution. Controls the lower end of the distribution.
}
\item{gamma}{
Parameter of Kagan distribution. Controls the upper end of the distribution.
}
\item{M0}{
Lowest magnitude under consideration.
}
\item{mag}{
Flag indicating whether stress or magnitudes are to be used. Default is true where stresses are used.
}
\item{theta}{
Parameter of \code{magnitude.convert}.
}
\item{phi}{
Parameter of \code{magnitude.convert}.
}}
\value{
    Density (\code{dkagan}), probability (\code{pkagan}), quantile
    (\code{qkagan}) or random sample (\code{rkagan}) for the Kagan
    distribution. The cumulative density function is given by:
    \deqn{
	F(x) = 1-\left\{\left(1 + \frac{x}{\beta}\right)^{-\alpha} \exp\left(\frac{-x}{\delta}\right)\right\}
    }{
	F(x) = 1-((1 + (x/beta))^(-alpha))*(exp(-x/delta))
    }
    where \eqn{x}{\code{x}}, \code{beta} \eqn{(\beta)}{} and
    \code{delta} \eqn{(\delta)}{} are to be interpreted
    as stresses according to the relation:
    \deqn{
	S(M) = 10^{\phi + \theta M}.
    }{
	S(M) = 10^(phi + theta * M).
    }
}
\details{
Elements of \code{p} or \code{M} that are missing will cause the corresponding elements of the result to be missing.

The variables in this basic form of the distribution correspond physically to moments (stress, benioff strain relief). The alternative form allows the parameters and variable to be specified in terms of magnitudes. Once the appropriate values are calculated, if need be, they can be transformed to magnitudes using the \code{\link{magnitude.convert}} function.
}
\section{Warning}{
The function \code{qkagan} uses a approximate numerical method (Newton-Raphson) to evaluate the quantile. 
}

\references{
Vere-Jones, D.; Robinson, R. & Yang, W. (2001). Remarks on the accelerated moment release model: problems of model formulation, simulation and estimation. \emph{Geophysical Journal International} \bold{144}, 517--531.

Kagan, Y.Y. (1997). Seismic moment-frequency relation for shallow earthquakes: Regional comparison. \emph{Journal of Geophysical Research} \bold{102}, 2835--2852. 
}

\seealso{
\code{\link{magnitude.convert}}
}

\examples{
#  Examine the Gutenberg-Richter Law:
#  Use default parameters

x <- seq(0, 10, length=1000)
plot(log(x), log(1-pkagan(x)), type="l")
}

\keyword{distribution}

