\name{epicentres.identify}
\alias{epicentres.identify}
\title{
Identify Epicentre Outliers
}
\description{
Plots earthquake epicentres selected from a given catalogue. The points are plotted on the screen, and then may be identified.
}
\usage{
epicentres.identify(events, mapname = "world2", criteria = TRUE)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{mapname}{
character string giving the map name. Low resolution maps contained in package \pkg{maps} are \code{"nz"} and \code{"world2"} (default). High resolution maps contained in the package \pkg{mapdata} are \code{"nzHires"}, \code{"world2Hires"} and \code{"china"}. The \dQuote{2} on \code{"world2"} denotes the version where the longitudes are all positive.
}
\item{criteria}{
boolean variable. If \code{TRUE} (default) the subsetting parameters are printed
below the graph.}
}
\value{
A vector of indices (into the original catalogue) of the points identified.
}
\details{
The points are plotted on an appropriate map, and points which are
considered to be outliers are highlighted with larger circles.  After the
points have been plotted, the \code{identify} command is used for
the user to identify points of interest.  Use the left mouse button to
select points (which are then identified on the map with their sequence
number within the list of points plotted).  Then use the middle or right
button to terminate the identification process.
}
\seealso{
\code{\link{epicentres}}, \code{\link{identify}}
}
\examples{
data(NZ55)

a <- subsetrect(NZ55, minmag=6.5)
b <- epicentres.identify(a, mapname = "nz")
if (length(b) > 0) print(NZ55[b,])
}

\keyword{iplot}

