\name{est.kagan}
\alias{est.kagan}
\title{Estimate Parameters of Kagan Distribution}
\description{
  Estimate different parameter or parameters of Kagan distribution for a given data set.
}
\usage{
est.kagan(Data, alpha=1, beta=0, gamma=7, theta=0.75, phi=2.4, tol=10^-3,
          Mag=TRUE, deltam=2)
}
\arguments{
  \item{Data}{ Vector of magnitude or stress.}
  \item{alpha}{ Parameter of Kagan distribution. Index of the power law. }
  \item{beta}{  Parameter of Kagan distribution. Control the lower turning point of distribution.}
  \item{gamma}{ Parameter of Kagan distribution. Control the upper turning point of the distribution.}
  \item{theta}{ Parameter of \code{\link{magnitude.convert}}.}
  \item{phi}{ Parameter of \code{magnitude.convert}.}
  \item{tol}{ minimum step length of Newton-Raphson algorithm.}
  \item{Mag}{ Flag indicating whether stress or magnitude is to be used.}
  \item{deltam}{ Range for scanning over \code{beta} parameter.}
}
\details{
Data is given in magnitudes or stress. Under the condition of data
following Kagan distribution, parameters of distribution could be
estimated, Newton-Raphson algorithm and maximum likelihood method are
used here.
}
\value{
Vector of estimated (or fixed) parameters \code{alpha} \eqn{(\alpha)}{},
\code{beta} \eqn{(\beta)}{} and \code{gamma} \eqn{(\gamma)}{} of the
Kagan distribution, the value of \code{M0} (minimum magnitude) determined from
the data and loglikelihood value that those parameters correspond to.
}

\references{
Vere-Jones, D.; Robinson, R. & Yang, W. (2001). Remarks on the accelerated moment release model: problems of model formulation, simulation and estimation. \emph{Geophysical Journal International} \bold{144}, 517--531.
}
\author{Wang Lifeng, 2001}

\section{Warning }{When the parameters of distribution are all unknown,
 the estimated results are sometimes not very accurate.}

\seealso{\code{\link{dkagan}}}

\examples{
estimate.alph <- NULL
for (i in 1:100)
{
    # follow Kagan distribution, using default parameters.
    stress <- rkagan(1000, mag = FALSE) # simulate data set of stress which
    # when alpha is unknown.
    alpha <- est.kagan(stress, alpha = NA, Mag = FALSE) # estimate alpha,
    estimate.alph <- rbind(estimate.alph, alpha)
}

# Get distribution of alpha estimated from the 100 samples.  This
# way, we could know possible distance between estimated one
# and real one. 
hist(estimate.alph[, 1], xlab="Alpha", ylab="Frequency", main="")
box()
}

\keyword{distribution}
