\name{freq.cusum}
\alias{freq.cusum}
\title{
Frequency Cusum Plot
}
\description{
Draws a cusum of event frequencies over time. The target value is the estimated mean frequency in the training period.
}
\usage{
freq.cusum(events, delta=1, trainyears=7)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{delta}{
number of months in each counted interval. Default is 1. 
}
\item{trainyears}{
number of years in the training period.
}}
\seealso{
\code{\link{depth.hist}}, \code{\link{freq.magnitude}},
\code{\link{magnitude.cusum}}, \code{\link{magnitude.time}},
\code{\link{epicentres}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

b <- subsetrect(NZ, minday=julian(1,1,1964), maxday=julian(1,1,1994),
                 mindepth=40, maxdepth=120, minmag=4)

freq.cusum(b)
}

\keyword{hplot}

