\name{freq.magnitude}
\alias{freq.magnitude}
\title{
Frequency Magnitude Plot
}
\description{
Frequency-magnitude plot of the selected events. That is, for a given magnitude \eqn{m} (\eqn{x} axis), the log10 of the proportion of events with magnitude greater than \eqn{m} is given on the \eqn{y} axis. The slope is commonly referred to as the b-value.
}
\usage{
freq.magnitude(events, delta=0.1, bvalue=NA, estimate="ml", plot=TRUE)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{delta}{
the interval width between points on the graph. Note that the limits of
magnitudes plotted (\eqn{x} axis) are determined by \code{minmag} and
\code{maxmag} in the object events. Hence, \code{maxmag-minmag} must be
a multiple of \code{delta}.
}
\item{bvalue}{
default is \code{NA}, in which case a least squares regression line is
fitted through the points. If not \code{NA}, a line with the given slope
is plotted.
}
\item{estimate}{
    takes the values \code{"ml"} (default) or \code{"ls"}, meaning maximum
    likelihood or least squares respectively. It determines the
    estimation method used for the b-value. In the case of least
    squares, the intercept parameter is estimated, whereas in the case
    of maximum likelihood the log of the cumulative proportion is set to
    zero at the minimum magnitude.}
\item{plot}{logical, default is \code{TRUE}. Determines whether the frequency magnitude distribution is plotted.}
}
\value{
The estimated b-value is returned if the function call is assigned to an object, otherwise \code{NULL}.
}
\seealso{
\code{\link{depth.hist}}, \code{\link{freq.cusum}},
\code{\link{magnitude.cusum}}, \code{\link{magnitude.time}},
\code{\link{epicentres}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

b <- subsetrect(NZ, minday=julian(1,1,1964), maxday=julian(1,1,1993), 
                mindepth=40, maxdepth=120, minmag=4)

freq.magnitude(b)
}

\keyword{hplot}

