\name{magnitude.contour}
\alias{magnitude.contour}
\title{
Mean Magnitude Contours
}
\description{
This function calculates mean magnitude contours at a pre-specified depth.
}
\usage{
magnitude.contour(events, h=c(0.3, 0.2, 10), depth=10)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{h}{
a vector of length three.  It specifies the bandwidths for the kernel function (see Details).
}
\item{depth}{
specifies the longitude-latitude plane where the b-value contours are plotted.
}}
\value{
NULL
}
\details{
The mean magnitude contours are produced using local linear regression technique described in Ruppert and Wand (1994) using a standard trivariate normal kernel. The smoothness of the contours is controlled by the bandwidths of the kernel.
}
\references{
Ruppert, D. & Wand, M.P. (1994).  Multivariate locally weighted least 
squares regression.  \emph{Ann. Statist.} \bold{22}, 1346--1370.
}
\author{
Edwin Choi (ANU), 1997
}
\seealso{
\code{\link{bvalue.contour}}
}

\examples{
#    This example requires the NZ catalogue

require(ssNZ)

#   Remember the parameters of the graphics device
par.reset <- par(no.readonly=TRUE)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

b <- subsetrect(Wellington, maxdepth=100, minmag=3,
                minlat=-42.2, maxlat=-40.5, minlong=173.6, maxlong=176.0,
                minday=julian(1,1,1980), maxday=julian(1,1,2000))

par(pty="s")
magnitude.contour(b, h=c(0.25, 0.2, 2), depth=10)
map("nz", add=TRUE, col="red")
par(par.reset)
}

\keyword{hplot}

