\name{magnitude.convert}
\alias{magnitude.convert}
\title{
Magnitude-Moment Conversion
}
\description{
Converts magnitudes to Benioff moments and vice versa.
}
\usage{
magnitude.convert(m, phi=0.75, B=2.4, inverse=FALSE)
}
\arguments{
\item{m}{
A vector to which the \code{\link{magnitude.convert}} function is applied.
}
\item{phi}{
parameter of the Benioff Moment.
}
\item{B}{
parameter of the Benioff Moment.
}
\item{inverse}{
logical. If \code{inverse} is \code{FALSE}, the Benioff Moment is returned. If \code{inverse} is \code{TRUE}, the magnitude is returned.
}}
\value{
    The Benioff Moment is defined as:
    \deqn{
	S(m) = 10 ^ {\phi m}.
    }{
	S(m) = 10**(phi * m + B)
    }
    The inverse is:
    \deqn{
	S(s)^{-1} = \frac{\log10(s)-B}{\phi}.
    }{
	S(s)**(-1) =  (log10(s)-B)/phi
    }
}
\references{
Kagan, Y.Y. (1997). Seismic moment-frequency relation for shallow
earthquakes: Regional comparison. \emph{Journal of Geophysical Research}
\bold{102}, 2835--2852. 

Kanamori, H. & Anderson, D.L. (1975). Theoretical basis of some
empirical relations in seismology. \emph{Bulletin of the Seismological
 Society of America} \bold{65}(5), 1073--1095.

Vere-Jones, D.; Robinson, R. & Yang, W. (2001). Remarks on the accelerated moment release model: problems of model
formulation, simulation and estimation. \emph{Geophysical Journal International} \bold{144}, 517--531.
}

\author{Alistair Merrifield, 1998}

\seealso{
\code{\link{pkagan}}, \code{\link{qkagan}}, \code{\link{rkagan}}, \code{\link{dkagan}}
}
\examples{
magnitudes <- seq(0, 11, length=100)
moments <- magnitude.convert(magnitudes)
magnitudes <- magnitude.convert(moments, inverse=TRUE)
}

\keyword{manip}

