\name{magnitude.cusum}
\alias{magnitude.cusum}
\title{
Cusum Magnitude Plot
}
\description{
Draws a cusum of event magnitudes over time. The target value is the estimated mean magnitude in the training period.
}
\usage{
magnitude.cusum(events, trainyears=7, at.breaks=NA)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{trainyears}{
length of the training period in years.
}
\item{at.breaks}{
positions of labelled tick marks on the third (top) axis. Default is January of each year.
}}
\seealso{
\code{\link{depth.hist}}, \code{\link{freq.cusum}},
\code{\link{freq.magnitude}}, \code{\link{magnitude.time}},
\code{\link{epicentres}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

b <- subsetrect(NZ, minday=julian(1,1,1964), maxday=julian(1,1,1994),
                 mindepth=40, maxdepth=120, minmag=4)

magnitude.cusum(b)
}

\keyword{hplot}

