\name{magnitude.time}
\alias{magnitude.time}
\title{
Magnitude Time Plot
}
\description{
Plots event magnitudes over time.
}
\usage{
magnitude.time(events)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}}
\seealso{
\code{\link{depth.hist}}, \code{\link{freq.cusum}},
\code{\link{freq.magnitude}}, \code{\link{magnitude.cusum}},
\code{\link{epicentres}}, \code{\link{threeD}}, \code{\link{timeplot}},
\code{\link{multigraph}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

#   Make the Wellington Catalogue
as.catalogue(subsetrect(NZ, minlat=-42.2, maxlat=-40.5,
             minlong=173.6, maxlong=176.0, minday=julian(1,1,1978)),
             catname="Wellington")

#    Cape Palliser Earthquake Sequence
b <- subsetcircle(Wellington, centrelong=175.5, centrelat=-41.65,
                  maxradius=20, minday=julian(1,1,1990),
                  maxday=julian(1,1,1993), maxdepth=40)
magnitude.time(b)
title(main="Cape Palliser Earthquake Sequence")
}

\keyword{hplot}

