\name{major}
\alias{major}
\title{Major Earthquake Events}
\description{
This page contains a listing of major earthquake events. They all \code{\link{require}} certain catalogues to be installed.
}

\examples{
#   Remember the parameters of the graphics device
#   Run this first, else the plots will get progressively smaller

par.reset <- par(no.readonly=TRUE)

#--------------------------------------------------------------------
event <- "Sumatra (Nias) Earthquake - 28 March 2005"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(92, 104, -5, 7)
a <- subsetrect(PDE, minday=julian(3, 1, 2005),
                 maxday=julian(8, 1, 2005), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=4)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(4, 5, 6, 7, 8),
           cex=c(0.2, 1, 2, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Phuket Thailand Earthquake - 26 Dec 2004"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(89, 105, 0, 16)
a <- subsetrect(PDE, minday=julian(12, 1, 2004),
                 maxday=julian(3, 1, 2005), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=5)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(5, 6, 7, 8),
           cex=c(0.2, 1, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Parkfield California Earthquake - 28 Sept 2004"

require(ssSCEC)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(238, 241, 35, 37)
a <- subsetrect(SCEC, minday=julian(9, 1, 2004),
                 maxday=julian(1, 1, 2005), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=2)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(2, 3, 4, 5, 6, 7),
           cex=c(0.2, 0.5, 1, 3, 5), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Alaska (Denali) Earthquake - 3 November 2002"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(200, 220, 55, 66)
a <- subsetrect(PDE, minday=julian(11, 1, 2002),
                 maxday=julian(7, 1, 2003), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=4)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(4, 5, 6, 7, 8),
           cex=c(0.2, 1, 2, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Hector Mine California Earthquake - 16 October 1999"

require(ssSCEC)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(240, 246, 32, 38)
a <- subsetrect(SCEC, minday=julian(10, 1, 1999),
                 maxday=julian(7, 1, 2000), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=3)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(3, 5, 6, 7, 8),
           cex=c(0.2, 1, 2, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Kobe Japan Earthquake - 17 January 1995"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(133, 137, 32, 36)
a <- subsetrect(PDE, minday=julian(1, 10, 1995),
                 maxday=julian(12, 31, 1995), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=4)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(4, 5, 6, 7),
           cex=c(1, 2, 3), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Northridge California Earthquake - 17 January 1994"

require(ssSCEC)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(240, 245, 33, 36)
a <- subsetrect(SCEC, minday=julian(1, 1, 1994),
                 maxday=julian(7, 1, 1994), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=3)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(3, 5, 6, 7),
           cex=c(0.2, 1, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Landers California Earthquake - 28 June 1992"

require(ssSCEC)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(240, 246, 32, 38)
a <- subsetrect(SCEC, minday=julian(6, 1, 1992),
                 maxday=julian(1, 1, 1993), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=3)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(3, 5, 6, 7, 8),
           cex=c(0.2, 1, 2, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Loma Prieta Earthquake - 18 October 1989"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(237, 239, 36.5, 38.5)
a <- subsetrect(PDE, minday=julian(10, 1, 1989),
                 maxday=julian(7, 1, 1990), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=3)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(3, 5, 6, 7),
           cex=c(0.2, 1, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Edgecumbe NZ Earthquake - 2 March 1987"

require(ssNZ)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(176, 178, -38.5, -36.5)
a <- subsetrect(NZ, minday=julian(1, 1, 1987),
                 maxday=julian(1, 1, 1988), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=3)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(3, 5, 6, 7),
           cex=c(0.2, 1, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)



#---------------------------------------------------------
event <- "Tangshan China Earthquake - 26 July 1976"

require(ssPDE)
if (require(mapdata)) mpnm <- "world2Hires" else mpnm <- "world2"

usr <- c(116, 120, 38, 41)
a <- subsetrect(PDE, minday=julian(7, 1, 1976),
                 maxday=julian(1, 1, 1977), minlong=usr[1],
                 maxlong=usr[2], minlat=usr[3], maxlat=usr[4],
                 minmag=4)
epicentres(a, usr=usr, mapname=mpnm, magnitude=c(4, 5, 6, 7, 8),
           cex=c(0.2, 1, 2, 4), criteria=FALSE)
title(main=event)
par(par.reset)
magnitude.time(a)
title(main=event)
as.catalogue(a, catname="temp")
print(temp)
}

\keyword{documentation}

