\name{map1}
\alias{map1}
\title{Draw Geographical Map}
\description{
Draws a geographical map with a rectangular projection. The user specifies the exact boundaries (latitude and longitude) of the map. The map is plotted to the current graphics device. If one is not open, a device of the default type will be opened.
}
\usage{
map1(mapname, usr, axes = TRUE, reset = TRUE, col = "gray35")
}

\arguments{
\item{mapname}{
character string giving the map name. Low resolution maps contained in package \pkg{maps} are \code{"nz"} and \code{"world2"} (default). High resolution maps contained in the package \pkg{mapdata} are \code{"nzHires"}, \code{"world2Hires"} and \code{"chinaHires"}. The \dQuote{2} on \code{"world2"} denotes the version where the longitudes are all positive.
}
\item{usr}{
a vector of length 4 than defines boundary positions (longitudes and latitudes) of the axes, i.e. \code{c(xmin, xmax, ymin, ymax)}.
}
\item{axes}{
logical variable. If \code{TRUE} (default), axes are added to the map, \code{FALSE} otherwise.
}
\item{reset}{
logical variable. If \code{TRUE} (default), the graphics device parameters are reset to their initial values, and \code{FALSE} will leave them the same as those used to plot the current map.
}
\item{col}{the colour of the map outline, specified either as a character string or the number representing the required colour in current palette.}
}

\details{
It is assumed that generally the user will want to add further features to the map. In this situation, the argument \code{reset} should be set to \code{FALSE}. In this situation the sizes of the margins and area within the axes will remain the same.

If one subsequently wants to put a different plot onto the graphics device, then the graphics parameters (\code{\link[base]{par}}) would need to be reset. See Examples below.
}

\author{David Harte, 2004}

\seealso{
\code{\link[maps]{map}}, \code{\link{epicentres}}
}

\examples{
par.reset <- par(no.readonly=TRUE)

map1(mapname="nz", usr=c(166, 179, -48, -34), reset=FALSE)
title(main="New Zealand")
par(par.reset)

map1(mapname="world2", usr=c(220, 320, 10, 80), reset=FALSE)
title(main="North America")
par(par.reset)

map1(mapname="world2", usr=c(90, 170, -20, 30), reset=FALSE)
title(main="South-East Asia")
par(par.reset)

map1(mapname="world", usr=c(-12, 40, 34, 65), reset=FALSE)
title(main="Europe")
par(par.reset)

map1(mapname="world", usr=c(-20, 60, -40, 45), reset=FALSE)
title(main="Africa")
par(par.reset)
}

\keyword{hplot}

