\name{multigraph}
\alias{multigraph}
\title{
Plot Multiple Graphs
}
\description{
Graph of multiple plots of events satisfying selection criteria.
}
\usage{
multigraph(events, plots, ncols=1, title="", criteria=TRUE)
}
\arguments{
\item{events}{
defines the events to be plotted. It is an object of class \code{"subset"}, generally created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{plots}{
    list object of plot functions. Plot functions that can be included
    are those with the single events argument. Some of these are:
    \code{depth.hist}, \code{freq.cusum},
    \code{freq.magnitude}, \code{magnitude.cusum},
    \code{magnitude.time}, \code{timeplot}.
}
\item{ncols}{
number of columns. Graphs are laid out in a matrix format, positions being filled row by row.
}
\item{title}{
overall title for the collection of all graphs.
}
\item{criteria}{
logical, default is \code{TRUE}. Determines whether the subsetting criteria is written at the bottom of the page.
}}
\seealso{
\code{\link{depth.hist}}, \code{\link{freq.cusum}},
\code{\link{freq.magnitude}}, \code{\link{magnitude.cusum}},
\code{\link{magnitude.time}}, \code{\link{epicentres}}, \code{\link{threeD}},
\code{\link{timeplot}}
}
\examples{
#    This example requires the NZ catalogue

require(ssNZ)

b <- subsetrect(NZ, minday=julian(1,1,1964), maxday=julian(1,1,1994),
                 mindepth=40, maxdepth=120, minmag=4)

multigraph(b,list(depth.hist, timeplot, magnitude.time,
                  freq.magnitude, freq.cusum, magnitude.cusum),
           ncols=3, title="Catalogue Completeness Analysis")
}

\keyword{hplot}

