\name{plot.subset}
\alias{plot.subset}
\title{
Method for Generic Function Plot
}
\description{
Plots four summary graphs for the selected subset: frequency-magnitude plot, depth histogram, counts by year, and magnitude-time plot.
}
\usage{
\method{plot}{subset}(x, ...)
}
\arguments{
\item{x}{
defines the events to be plotted. It is an object with class \code{"subset"} created by \code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}} or \code{\link[ssBase]{subsetsphere}}.
}
\item{\dots}{
other options for plotting \code{"subset"} objects.
}
}
\value{
NULL
}
\seealso{
\code{\link[ssBase]{subsetcircle}}, \code{\link[ssBase]{subsetpolygon}}, \code{\link[ssBase]{subsetrect}}, \code{\link[ssBase]{subsetsphere}}
}

\examples{
data(NZ55)
a <- subsetrect(NZ55, minday=julian(1,1,1970))
plot(a)
}

\keyword{methods}
\keyword{hplot}
